$(document).ready(async function () {
  let resultadoConsulta = [];

  let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));

  if (colunas == null || colunas.financeiroClasseGer == undefined) {
    localStorage.setItem(
      "colunasInvisiveisRelatorios",
      JSON.stringify({ ...colunas, financeiroClasseGer: [] })
    );
    colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
  }

  // addTutorial();
  // preencheOrdenacaoTela("RelFaturamento");
  addPesquisaAutocompleta();

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnLimparFiltros").on("click", function () {
    limpaFiltros();
  });

  $("#btnSelecionarEmpresas").on("click", function () {
    carregaEmpresasDisponiveis();
  });

  $("#btnConfirmarColunas").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem(
        "colunasInvisiveisRelatorios",
        JSON.stringify({ ...colunas, financeiroClasseGer: novasColunas })
      );
      $("#tabelaFinanceiroClasse").DataTable().columns().visible(true);
      $("#tabelaFinanceiroClasse")
        .DataTable()
        .columns()
        .every(function () {
          if (novasColunas.indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay("hide");
      $("#modal-ColunasVisiveis").modal("hide");
    }
  });

  $("#modal-ColunasVisiveis").on("show.bs.modal", function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(
      localStorage.getItem("colunasInvisiveisRelatorios")
    );
    $("#tabelaFinanceiroClasse")
      .DataTable()
      .columns()
      .every(function () {
        cols.push({
          title: $(this.header()).text(),
          data: this.dataSrc(),
        });
      });
    adicionaColunas(cols, colunasInvisiveis.financeiroClasseGer ?? []);
  });

  $("#btnConsultar").on("click", async function () {
    $.LoadingOverlay("show");
    resultadoConsulta = [];
    let valorReceber = 0;
    let valorPagar = 0;
    let valorFinal = 0;
    let valorReceberFixo = 0;
    let valorReceberVariavel = 0;
    let valorPagarFixo = 0;
    let valorPagarVariavel = 0;

    let tabelaFinanceiroClasseColVis = false;
    let tabelaDadosFinanceiroColVis = false;

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas === null || colunas.relfinanceiroclasseger_FinanceiroClasse === undefined) {
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relfinanceiroclasseger_FinanceiroClasse: [] }));
      colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    };

    if (colunas === null || colunas.relfinanceiroclasseger_DadosFinanceiro === undefined) {
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relfinanceiroclasseger_DadosFinanceiro: [] }));
      colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    };

    try {
      const url = "/sisplan/impressao/v1/consultarelfinanceiroclasseger?";
      const filtros = await retornaFiltros();

      const valueOperacao = $("#selectOperacao").val();

      if (valueOperacao == "E") {
        if ($("#dtReceitaDe").val() == "") {
          msgAlerta(
            'Filtrado operação de entrada mas não foi informado nos filtros "Data Receita De". Verifique e tente novamente.'
          );
          return;
        }

        if ($("#dtReceitaAte").val() == "") {
          msgAlerta(
            'Filtrado operação de entrada mas não foi informado nos filtros "Data Receita Até". Verifique e tente novamente.'
          );
          return;
        }
      } else if (valueOperacao == "S") {
        if ($("#dtPagtoDe").val() == "") {
          msgAlerta(
            'Filtrado operação de saída mas não foi informado nos filtros "Data Pagamento De". Verifique e tente novamente.'
          );
          return;
        }

        if ($("#dtPagtoAte").val() == "") {
          msgAlerta(
            'Filtrado operação de saída mas não foi informado nos filtros "Data Pagamento Até". Verifique e tente novamente.'
          );
          return;
        }
      } else {
        if ($("#dtReceitaDe").val() == "") {
          msgAlerta(
            'Filtrado todas as operações mas não foi informado nos filtros "Data Receita De". Verifique e tente novamente.'
          );
          return;
        }

        if ($("#dtReceitaAte").val() == "") {
          msgAlerta(
            'Filtrado todas as operações mas não foi informado nos filtros "Data Receita Até". Verifique e tente novamente.'
          );
          return;
        }

        if ($("#dtPagtoDe").val() == "") {
          msgAlerta(
            'Filtrado todas as operações mas não foi informado nos filtros "Data Pagamento De". Verifique e tente novamente.'
          );
          return;
        }

        if ($("#dtPagtoAte").val() == "") {
          msgAlerta(
            'Filtrado todas as operações mas não foi informado nos filtros "Data Pagamento Até". Verifique e tente novamente.'
          );
          return;
        }
      }

      const response = await requisicao("GET", url, filtros, 1300000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        limpaFiltros();
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let listaEstruturas = [];

      for (let i = 0; i < jsonStr.length; i++) {
        if (jsonStr[i].OPERACAO == "+") {
          valorReceber += jsonStr[i].VALOR;
        } else if (jsonStr[i].OPERACAO == "-") {
          valorPagar += jsonStr[i].VALOR;
        }

        if (jsonStr[i].OPERACAO == "+" && jsonStr[i].TP_CUSTO == "FIXO") {
          valorReceberFixo += jsonStr[i].VALOR;
        } else if (
          jsonStr[i].OPERACAO == "+" &&
          jsonStr[i].TP_CUSTO == "VARIAVEL"
        ) {
          valorReceberVariavel += jsonStr[i].VALOR;
        }

        if (jsonStr[i].OPERACAO == "-" && jsonStr[i].TP_CUSTO == "FIXO") {
          valorPagarFixo += jsonStr[i].VALOR;
        } else if (
          jsonStr[i].OPERACAO == "-" &&
          jsonStr[i].TP_CUSTO == "VARIAVEL"
        ) {
          valorPagarVariavel += jsonStr[i].VALOR;
        }

        if (listaEstruturas.length > 0) {
          const index = listaEstruturas.findIndex(
            (item) =>
              item.ESTRUTURA == jsonStr[i].ESTRUTURA &&
              item.COD_CLASSE == jsonStr[i].COD_CLASSE &&
              item.OPERACAO == jsonStr[i].OPERACAO
          );

          if (index != -1) {
            listaEstruturas[index].VALOR += jsonStr[i].VALOR;
          } else {
            const obj = {
              ESTRUTURA: jsonStr[i].ESTRUTURA,
              COD_CLASSE: jsonStr[i].COD_CLASSE,
              OPERACAO: jsonStr[i].OPERACAO,
              VALOR: jsonStr[i].VALOR,
              NOME_CLASSE: jsonStr[i].NOME_CLASSE,
              TP_CUSTO: jsonStr[i].TP_CUSTO,
            };

            listaEstruturas.push(obj);
          }
        } else {
          const obj = {
            ESTRUTURA: jsonStr[i].ESTRUTURA,
            COD_CLASSE: jsonStr[i].COD_CLASSE,
            OPERACAO: jsonStr[i].OPERACAO,
            VALOR: jsonStr[i].VALOR,
            NOME_CLASSE: jsonStr[i].NOME_CLASSE,
            TP_CUSTO: jsonStr[i].TP_CUSTO,
          };

          listaEstruturas.push(obj);
        }
      }

      valorFinal = valorReceber - -valorPagar;

      $("#txt_val_receber_total").text(
        valorReceber.toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        })
      );
      $("#txt_val_pagar_total").text(
        valorPagar.toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        })
      );
      $("#txt_val_final_total").text(
        valorFinal.toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        })
      );
      if (valorFinal >= 0) {
        $("#spanTotalFinal").css("background-color", "var(--info-box-success)");
      } else {
        $("#spanTotalFinal").css("background-color", "var(--info-box-danger)");
      }
      $("#txt_val_receber_fixo_total").text(
        valorReceberFixo.toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        })
      );
      $("#txt_val_receber_variavel_total").text(
        valorReceberVariavel.toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        })
      );
      $("#txt_val_pagar_fixo_total").text(
        valorPagarFixo.toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        })
      );
      $("#txt_val_pagar_variavel_total").text(
        valorPagarVariavel.toLocaleString("pt-BR", {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        })
      );

      $("#tabelaFinanceiroClasse").DataTable({
        search: false,
        filter: true,
        order: [],
        sort: false,
        destroy: true,
        pageLength: 10,
        scrollY: "27.5vh",
        paging: true,
        "autoWidth": true,
        autoWidth: true,
        "colReorder": false,
        columnDefs: [
          {
            targets: [5],
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2,
              });
            },
            className: "pr-4 text-right",
          },
          {
            targets: 5,
            createdCell: function (td, cellData) {
              if (cellData >= 0) {
                $(td).css({
                  color: "green",
                  "font-weight": "bold",
                });
              } else {
                $(td).css({
                  color: "red",
                  "font-weight": "bold",
                });
              }
            },
          },
        ],
        data: listaEstruturas,
        columns: [
          {
            title: "Estrutura",
            data: "ESTRUTURA",
          },
          {
            title: "Classe Ger.",
            data: "COD_CLASSE",
          },
          {
            title: "Desc. Classe",
            data: "NOME_CLASSE",
          },
          {
            title: "Tipo Custo",
            data: "TP_CUSTO",
          },
          {
            title: "Operação",
            data: "OPERACAO",
          },
          {
            title: "Valor",
            data: "VALOR",
          },
        ],
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      $('#tabelaFinanceiroClasse_length').prepend('<button class="buttonColVis" id="buttonColVis_finClasse"><i class="fas fa-cogs"></i></button>');
      $('#tabelaFinanceiroClasse_length').prepend('<button class="buttonExcel" id="buttonExcel_finClasse"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis_finClasse').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel_finClasse').prop('title', 'Exportar CSV')

      $('#buttonColVis_finClasse').on('click', async function () {
        $.LoadingOverlay('show');
        try {
          setarTabelaEdicao("#tabelaFinanceiroClasse");
          $('#modal-ColunasVisiveis').modal('show');
        } finally {
          $.LoadingOverlay('hide');
        };
      });

      $('#buttonExcel_finClasse').on('click', async function () {
        $.LoadingOverlay('show');
        try {
          const dados = $("#tabelaFinanceiroClasse").DataTable().data().toArray();
          await exportaCSV("", "", undefined, null, 'Relatório de Financeiro Por Classe Gerencial', '', '', 999, false, false, dados);
        } catch (error) {
          console.log(error.message);
        } finally {
          $.LoadingOverlay('hide');
        };
      });

      $('#tabelaFinanceiroClasse').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relfinanceiroclasseger_FinanceiroClasse).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          };
        }
      );

      resultadoConsulta = jsonStr;

      $("#tabelaDadosFinanceiro").DataTable({
        destroy: true,
        lengthChange: true,
        serverside: false,
        search: true,
        pageLength: 10,
        autoWidth: true,
        scrollY: "27.5vh",
        order: [[5, "desc"]],
        columnDefs: [
          {
            targets: [4],
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2,
              });
            },
            className: "pr-4 text-right",
          },
          {
            targets: [5],
            render(data) {
              return (
                parseFloat(data).toLocaleString("pt-BR", {
                  minimumFractionDigits: 2,
                  maximumFractionDigits: 2,
                }) + " %"
              );
            },
            className: "pr-4 text-right",
          },
          {
            targets: [6],
            visible: false,
          },
          {
            targets: 4,
            createdCell: function (td, cellData) {
              if (cellData >= 0) {
                $(td).css({
                  color: "green",
                  "font-weight": "bold",
                });
              } else {
                $(td).css({
                  color: "red",
                  "font-weight": "bold",
                });
              }
            },
          },
          {
            targets: 5,
            createdCell: function (td, cellData) {
              $(td).css({
                color: "var(--perc-color)",
                "font-weight": "bold",
              });
            },
          },
        ],
        columns: [
          {
            title: "Nota Fiscal",
            data: "NOTA_FISCAL",
          },
          {
            title: "Número",
            data: "NUMERO",
          },
          {
            title: "Cliente/Fornecedor",
            data: "CODCLI",
          },
          {
            title: "Nome Cliente",
            data: "NOME",
          },
          {
            title: "Valor",
            data: "VALOR",
          },
          {
            title: "Porcentagem",
            data: "PORCENTAGEM",
          },
          {
            title: "Obs",
            data: "OBS",
          },
        ],
      });

      $('#tabelaDadosFinanceiro_length').prepend('<button class="buttonColVis" id="buttonColVis_dadosFin"><i class="fas fa-cogs"></i></button>');
      $('#tabelaDadosFinanceiro_length').prepend('<button class="buttonExcel" id="buttonExcel_dadosFin"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis_dadosFin').prop('title', 'Configurar colunas visíveis')
      $('#buttonColVis_dadosFin').prop('title', 'Exportar CSV')

      $('#buttonColVis_dadosFin').on('click', async function () {
        $.LoadingOverlay('show');
        try {
          setarTabelaEdicao("#tabelaDadosFinanceiro");
          $('#modal-ColunasVisiveis').modal('show');
        } finally {
          $.LoadingOverlay('hide');
        };
      });

      $('#buttonExcel_dadosFin').on('click', async function () {
        $.LoadingOverlay('show');
        try {
          const dados = $("#tabelaDadosFinanceiro").DataTable().data().toArray();
          await exportaCSV("", "", undefined, null, 'Relatório de Dados Financeiro', '', '', 999, false, false, dados);
        } catch (error) {
          console.log(error.message);
        } finally {
          $.LoadingOverlay('hide');
        };
      });

      $("#tabelaFinanceiroClasse tbody").on("click", "tr", async function () {
        $("#tabelaFinanceiroClasse")
          .dataTable()
          .$("tr.selected")
          .removeClass("selected");
        $(this).addClass("selected");
        const data = $("#tabelaFinanceiroClasse").DataTable().row(this).data();
        $("#tabelaDadosFinanceiro").DataTable().clear().draw(false);
        const listaResultados = resultadoConsulta.filter(
          (dados) =>
            dados.COD_CLASSE == data.COD_CLASSE &&
            dados.ESTRUTURA == data.ESTRUTURA &&
            dados.OPERACAO == data.OPERACAO
        );

        for (let v = 0; v < listaResultados.length; v++) {
          if (listaResultados[v].VALOR > 0) {
            listaResultados[v].PORCENTAGEM =
              (listaResultados[v].VALOR / data.VALOR) * 100;
          } else if (listaResultados[v].VALOR < 0) {
            listaResultados[v].PORCENTAGEM =
              ((listaResultados[v].VALOR * -1) / data.VALOR) * 100;
          } else {
            listaResultados[v].PORCENTAGEM = 0;
          }
        }

        $("#tabelaDadosFinanceiro")
          .DataTable()
          .rows.add(listaResultados)
          .draw(false);
        $("#tabelaDadosFinanceiro")
          .DataTable()
          .rows()
          .every(function () {
            $(this.node()).removeClass("selected");
          });

        $("#tabelaDadosFinanceiro tbody tr:first").trigger("click");
      });

      $("#tabelaDadosFinanceiro tbody").on("click", "tr", async function () {
        $("#tabelaDadosFinanceiro")
          .dataTable()
          .$("tr.selected")
          .removeClass("selected");
        $(this).addClass("selected");
        const data = $("#tabelaDadosFinanceiro").DataTable().row(this).data();
        $("#txtObsFinanceiro").text(data.OBS);
      });

      const dados = $("#tabelaFinanceiroClasse").DataTable().data().toArray();

      const dadosReceita = [];
      const dadosDespesa = [];

      dados.forEach((obj) => {
        if (obj.VALOR >= 0) {
          dadosReceita.push(obj);
        } else {
          obj.VALOR = -obj.VALOR;
          dadosDespesa.push(obj);
        }
      });

      Graficos.criarGrafico({
        container: "graficoRelFinanceiroClasseGer",
        tipo: "column",
        dados: dadosReceita,
        nomeSerie: "Receita",
        colunasAgrupamento: ["COD_CLASSE"],
        colunasValor: ["VALOR"],
        title: "Top 4 maiores receitas",
        formatarValor: (value) => {
          return value.toLocaleString("pt-BR", {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
          });
        },
        qtdeRegistros: 4,
      });

      Graficos.criarGrafico({
        container: "graficoRelFinanceiroClasseGer1",
        tipo: "column",
        dados: dadosDespesa,
        nomeSerie: "Despesa",
        colunasAgrupamento: ["COD_CLASSE"],
        colunasValor: ["VALOR"],
        title: "Top 4 maiores despesas",
        formatarValor: (value) => {
          return (
            "-" +
            value.toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
            })
          );
        },
        qtdeRegistros: 4,
      });

      const titlesReceitas = $(".highcharts-axis-labels")[0];

      for (let x = 0; x < titlesReceitas.children.length; x++) {
        const codClasse = $(titlesReceitas.children[x]).text();
        const objClasse = listaEstruturas.filter(
          (item) => item.COD_CLASSE == codClasse
        );
        $(titlesReceitas.children[x]).text(
          objClasse[0].NOME_CLASSE.substring(0, 25)
        );
      }

      const titlesDespesas = $(".highcharts-axis-labels")[3];

      for (let x = 0; x < titlesDespesas.children.length; x++) {
        const codClasse = $(titlesDespesas.children[x]).text();
        const objClasse = listaEstruturas.filter(
          (item) => item.COD_CLASSE == codClasse
        );
        $(titlesDespesas.children[x]).text(
          objClasse[0].NOME_CLASSE.substring(0, 25)
        );
      }

      $("#tabelaFinanceiroClasse tbody tr:first").trigger("click");

      const existeRegistroFinanceiroClasse =
        $("#tabelaFinanceiroClasse").DataTable().data().toArray().length > 0;

      const existeRegistroDadosFinanceiro =
        $("#tabelaDadosFinanceiro").DataTable().data().toArray().length > 0;

      if (existeRegistroFinanceiroClasse) {
        $("#btnImprimirFinanceiroClasse").removeClass("d-none");
      } else {
        $("#btnImprimirFinanceiroClasse").addClass("d-none");
      }

      if (existeRegistroDadosFinanceiro) {
        $("#btnImprimirDadosFinanceiro").removeClass("d-none");
      } else {
        $("#btnImprimirDadosFinanceiro").addClass("d-none");
      }
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
      $("#modal-filtros").modal("hide");
    }
  });

  retornaHintRelatorio("btnImprimirFinanceiroClasse", "RelFinanceiroClasseGer");
  retornaHintRelatorio("btnImprimirDadosFinanceiro", "RelDadosFinanceiro");

  $("#btnImprimirFinanceiroClasse").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const url = `/sisplan/impressao/v1/imprimirrelfinanceiroclasseger?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelFinanceiroClasseGer&TIPO_RELATORIO=RESUMIDO`;
        const bImprimeAutomatico = await verificaImprimirAutomatico(
          "RelFinanceiroClasseGer"
        );
        const arquivo = await GeraRelatorio(
          `${url}${filtros}${ordem}&`,
          "GET",
          100000,
          false,
          "RelFinanceiroClasseGer"
        );
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnImprimirDadosFinanceiro").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const rowSelecionada = $("#tabelaDadosFinanceiro").DataTable().row($("#tabelaDadosFinanceiro").DataTable().$("tr.selected")).data();
        const url = `/sisplan/impressao/v1/imprimirrelfinanceiroclasseger?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelDadosFinanceiroClasseGer&TIPO_RELATORIO=DETALHADO&CLASSE_GER_DADOS_FINANCEIRO=${rowSelecionada.COD_CLASSE}&ESTRUTURA_DADOS_FINANCEIRO=${rowSelecionada.ESTRUTURA}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico(
          "RelDadosFinanceiroClasseGer"
        );
        const arquivo = await GeraRelatorio(
          `${url}${filtros}${ordem}&`,
          "GET",
          100000,
          false,
          "RelDadosFinanceiroClasseGer"
        );
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  function limpaFiltros() {
    $("#dtReceitaDe").val("");
    $("#dtReceitaAte").val("");
    $("#dtPagtoDe").val("");
    $("#dtPagtoAte").val("");
    $("#txtClasse").empty().trigger("change");
    $("#txtFornecedor").empty().trigger("change");
    $("#selectOperacao").val("").change();
  }

  // async function bUsuarioMaster() {
  //   try {
  //     const usuario =
  //       (await retornaJsonPesquisaPadrao(
  //         `{"tabela": "ACESSO_USUARIOS", "camposSelect": ["TIPO"], "WHERE": ["CODIGO = '${getCookie(
  //           "cod_usuario"
  //         )}'"] }`
  //       )) ?? 0;

  //     return usuario[0].TIPO == "2";
  //   } catch (error) {
  //     console.error(error);
  //   }
  // }

  async function retornaFiltros() {
    let empresas =
      $(".empresa_selecionada:checked").toArray().length > 0
        ? $(".empresa_selecionada:checked")
            .toArray()
            .map((input) =>
              input.id.substring(input.id.indexOf("-") + 1, input.id.length)
            )
        : [getCookie("emp_id")];

    const fornecedor = await formataListas(
      $("#txtFornecedor").val().toString()
    );
    const classeGer = await formataListas($("#txtClasse").val().toString());
    const selectOperacao = $("#selectOperacao").val();

    const retorno =
      `DT_RECEITA_DE=${$("#dtReceitaDe").val()}` +
      `&DT_RECEITA_ATE=${$("#dtReceitaAte").val()}` +
      `&DT_PAGTO_DE=${$("#dtPagtoDe").val()}` +
      `&DT_PAGTO_ATE=${$("#dtPagtoAte").val()}` +
      `&FORNECEDOR=${fornecedor}` +
      `&CLASSE_GER=${classeGer}` +
      `&EMPRESAS_ID=${empresas}` +
      `&OPERACAO=${selectOperacao}`;
    return retorno;
  }

  function addPesquisaAutocompleta() {
    componenteFiltro("classe", true, true);
    componenteFiltro("fornecedor", true, true);
  }

  function setarTabelaEdicao(tabela) {
    tabelaFinanceiroClasseColVis = tabela === '#tabelaFinanceiroClasse';
    tabelaDadosFinanceiroColVis = tabela === '#tabelaDadosFinanceiro';
  };

  $('#btnConfirmarColunas').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const novasColunas = retornaNovasColunasInvisiveis();

      if (tabelaFinanceiroClasseColVis) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relfinanceiroclasseger_FinanceiroClasse: novasColunas }))
        $('#tabelaFinanceiroClasse').DataTable().columns().visible(true);
        $('#tabelaFinanceiroClasse').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            };
          }
        );
      } else if (tabelaDadosFinanceiroColVis) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relfinanceiroclasseger_DadosFinanceiro: novasColunas }))
        $('#tabelaDadosFinanceiro').DataTable().columns().visible(true);
        $('#tabelaDadosFinanceiro').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            };
          }
        );
      };

      tabelaFinanceiroClasseColVis = false;
      tabelaDadosFinanceiroColVis = false;
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    };
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    const tabela = tabelaFinanceiroClasseColVis ? "#tabelaFinanceiroClasse" : tabelaDadosFinanceiroColVis ? "#tabelaDadosFinanceiro" : "";

    $(tabela).DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    if (tabelaFinanceiroClasseColVis) {
      adicionaColunas(cols, colunasInvisiveis.relfinanceiroclasseger_FinanceiroClasse ?? []);
    } else if (tabelaDadosFinanceiroColVis) {
      colunasInvisiveis.relfinanceiroclasseger_DadosFinanceiro.push("OBS");
      adicionaColunas(cols, colunasInvisiveis.relfinanceiroclasseger_DadosFinanceiro ?? [], ["Obs"]);
    };
  });
});
