<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Regra Fiscal</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.257.10.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.257.10.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.257.10.1" />
  <link href='../dist/css/bootstrap.min.css?versao=3.257.10.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.257.10.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.257.10.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.257.10.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.257.10.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.257.10.1">
  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.257.10.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.257.10.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.257.10.1">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 33.33333%;
      float: left;
      position: relative
    }

    .labelGeral {
      margin-top: 7px;
      margin-bottom: 3px;
    }

    .labelCheck {
      font-size: 120%;
      /* border-bottom: outset 2px;
            border-left: outset 2px; */
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.2);
      -moz-transform: scale(1.2);
      -webkit-transform: scale(1.2);
      -o-transform: scale(1.2);
      transform: scale(1.2);
      padding: 10px;
    }

    .radioTipo {
      font-size: 120%;
    }

    .bTipo {
      position: absolute;
      margin-bottom: 50%;
      font-size: 120%;
      font-weight: bolder;
    }

    .pTipo {
      margin-top: 2%;
      margin-left: -1%;
      margin-bottom: 0%;
    }

    .pCartao {
      margin-left: -1%;
      margin-bottom: 0%;
      margin-top: 2%;
    }

    .valMin {
      margin-top: 2%;
    }

    .frete {
      margin-top: 2%;
      margin-left: 0.1%;
    }

    #contas-wrap {
      margin-top: 0%;
    }

    #labelcontas {
      margin-top: 2%;
    }

    .radioTop {
      margin-left: 2%;
      margin-top: 2%;
      padding-left: 1%;
      padding-top: 1%;
      padding-right: 1%;
      padding-bottom: 0%;
    }

    .labelFonte {
      font-size: 100%;
      margin-top: 20%;
    }

    .radiosStyle {
      margin-top: 0%;
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      margin-left: 0%;
    }

    .checkboxMoeda {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 1%;
      padding-left: 1.5%;
    }

    .checkboxTipo {
      margin-left: 0.1%;
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 1%;
      padding-bottom: 0%;
    }

    .labelTipo {
      margin-bottom: 3px;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>
    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
                <!-- <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item active">Cadastro Regra Fiscal</li>
                </ol> -->
              </div><!-- /.col -->
            </div><!-- /.row -->
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Cadastro de Regra Fiscal
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>
                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <!-- progressbar -->
                      <ul id="progressbar">
                        <li class="active" id="account"><strong>Geral</strong></li>
                        <li id="payment"><strong>Comparação</strong></li>
                        <li id="personal"><strong>Alterações</strong></li>
                      </ul> <!-- fieldsets -->
                      <p>Preencha os dados e clique em avançar para realizar o cadastro da regra fiscal</p>
                      <fieldset>
                        <div class="form-card" id="formcard1">
                          <h2 class="fs-title d-flex ">Dados Gerais
                            <div class="icheck-primary pl-3" style="margin: 6px 0 0 0 !important;"><input type="checkbox" checked id="checkAtivo"><label for="checkAtivo" style="font-size: 59%;">Ativo</label></div>
                          </h2>
                          <div class="row">
                            <div class="col-lg-6  col-12 form-group">
                              <div class="row">
                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código *</label>
                                  <div class="input-group">
                                    <input type="text" readonly class="input-default focus form-control" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Campo preenchido automaticamente">
                                  </div>
                                </div>
                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPrioridade">Prioridade *</label>
                                  <div class="input-group">
                                    <input type="number" class="input-default focus form-control" id="txtPrioridade" name="txtPrioridade" class="form-control" placeholder="Prioridade">
                                  </div>
                                </div>
                                <div class="col-lg-12  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtDescricao">Descrição regra *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtDescricao" name="txtDescricao" class="form-control" placeholder="Descrição da regra">
                                  </div>
                                </div>
                                <div class="col-lg-12  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtOperacaoFiscal">Operação fiscal *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtOperacaoFiscal" name="txtOperacaoFiscal" class="form-control" placeholder="Operação fiscal">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnOperacaoFiscal" name="btnEmpresa" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnAOperacaoFiscal" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-6  col-12 form-group">
                              <table id="tabelaEmpresa" class="table table-sm table-hover table-select table-condensed" style="white-space: nowrap;">
                                <thead>
                                  <tr>
                                    <th>Sel</th>
                                    <th>Empresa</th>
                                    <th>Fantasia</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="avancar1" class="btn-sisp next action-button" id="avancar1" value="Avançar" />
                        <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                      </fieldset>
                      <fieldset>
                        <div class="form-card">
                          <h2 class="fs-title">Campos de Comparação</h2>
                          <div class="row" id="tourcamposcomparacao">

                            <div class="col-lg-12 col-12 d-flex justify-content-start">
                              <input type="button" name="btnCFOP" class="action-button" value="CFOP" id="btnCFOP">
                              <input type="button" name="btnNCM" class="action-button" value="NCM" id="btnNCM">
                              <input type="button" name="btnEstados" class="action-button" value="ESTADOS" id="btnEstados">
                              <input type="button" name="btnEntidade" class="action-button" value="ENTIDADE" id="btnEntidade">
                              <input type="button" name="btnOrigem" class="action-button" value="ORIG. ITEM" id="btnOrigem">
                              <input type="button" name="btnCodSPED" class="action-button" value="COD. SPED" id="btnCodSPED">
                              <input type="button" name="btnEntidAux" class="action-button" value="ENTID. AUX" id="btnEntidAux">
                              <input type="button" name="btnPresenca" class="action-button" value="PRESENÇA" id="btnPresenca">
                              <input type="button" name="btnIndIE" class="action-button" value="INDICADOR IE" id="btnIndIE">
                              <input type="button" name="btnModelo" class="action-button" value="MODELO" id="btnModelo">
                            </div>

                            <div class="col-lg-4  col-12" style="padding-right: 2%;">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="tipoPessoa">Tipo Pessoa</label>
                              <div class="row form-group checkboxMoeda" id="tipoPessoa">
                                <div class="col-lg-12">
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkFisica"><label class="labelCheck" for="checkFisica">1 - Física</label></div>
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkJuridica"> <label class="labelCheck" for="checkJuridica">2 - Jurídica</label></div>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-4  col-12" style="padding-right: 2%;">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="consFinal">Consumidor Final</label>
                              <div class="row form-group checkboxMoeda" id="consFinal">
                                <div class="col-lg-12">
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkSim"><label class="labelCheck" for="checkSim">1 - Sim</label></div>
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkNao"><label class="labelCheck" for="checkNao">2 - Não</label></div>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-4  col-12">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="tipoVenda">Tipo Venda Item</label>
                              <div class="row form-group checkboxMoeda" id="tipoVenda">
                                <div class="col-lg-12">
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkProducao"><label class="labelCheck" for="checkProducao">0 - Produção</label></div>
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkRevenda"><label class="labelCheck" for="checkRevenda">1 - Revenda</label></div>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-12  col-12">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="porteCliente">Porte Cliente</label>
                              <div class="row form-group checkboxMoeda" id="porteCliente">
                                <div class="col-lg-3">
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkSA"><label class="labelCheck" for="checkSA">SA</label></div>
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkLTDA"><label class="labelCheck" for="checkLTDA">LTDA</label></div>
                                </div>
                                <div class="col-lg-3">
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkSimples"><label class="labelCheck" for="checkSimples">Simples</label></div>
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkME"><label class="labelCheck" for="checkME">ME</label></div>
                                </div>
                                <div class="col-lg-3">
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkEPP"><label class="labelCheck" for="checkEPP">EPP</label></div>
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkNormal"><label class="labelCheck" for="checkNormal">Normal</label></div>
                                </div>
                                <div class="col-lg-3">
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkMEI"><label class="labelCheck" for="checkMEI">MEI</label></div>
                                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkEireli"><label class="labelCheck" for="checkEireli">EIRELI</label></div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="avancar2" class="next action-button" value="Avançar" id="avancar2" />
                        <input type="button" name="voltar" class="previous action-button-previous" value="Voltar" id="voltar" />
                      </fieldset>
                      <fieldset>
                        <div class="form-card">
                          <h2 class="fs-title">Dados a serem alterados</h2>
                          <div class="row" id="campostouralteracao">
                            <div class="col-lg-12 col-12 d-flex justify-content-start">
                              <input type="button" name="btnICMS" class="action-button" value="ICMS" id="btnICMS">
                              <input type="button" name="btnIPI" class="action-button" value="IPI" id="btnIPI">
                              <input type="button" name="btnPISCOFINS" class="action-button" value="PIS/COFINS" id="btnPISCOFINS">
                              <input type="button" name="btnIVA" class="action-button" value="IVA" id="btnIVA">
                            </div>

                            <div class="col-lg-12 col-12 d-flex" style="margin-top: 1%;">
                              <div class="icheck-primary col"><input type="checkbox" class="configCheck" id="checkAplicaDesc"><label class="labelCheck" for="checkAplicaDesc">Aplica Desconto</label></div>
                              <div class="icheck-primary col"><input type="checkbox" class="configCheck" id="checkGeraDup"><label class="labelCheck" for="checkGeraDup">Gera Duplicata</label></div>
                              <div class="icheck-primary col"><input type="checkbox" class="configCheck" id="checkMVAZerada"><label class="labelCheck" for="checkMVAZerada">MVA Zerada</label></div>
                            </div>

                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtReducaoMVA">Redução/MVA</label>
                              <div class="input-group">
                                <input type="text" value="0.0000" class="input-default focus form-control" id="txtReducaoMVA" name="txtReducaoMVA" class="form-control" placeholder="Redução/MVA">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliqInternaUF">Alíq. interna da UF</label>
                              <div class="input-group">
                                <input type="text" value="0.00" class="input-default focus form-control" id="txtAliqInternaUF" name="txtAliqInternaUF" class="form-control" placeholder="Alíquota interna da UF">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercFCP">Percentual FCP</label>
                              <div class="input-group">
                                <input type="text" value="0.00" class="input-default focus form-control" id="txtPercFCP" name="txtPercFCP" class="form-control" placeholder="Percentual FCP">
                              </div>
                            </div>
                            <!-- -->
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCredPresumido">Crédito presumido</label>
                              <div class="input-group">
                                <input type="text" value="0.00" class="input-default focus form-control" id="txtCredPresumido" name="txtCredPresumido" class="form-control" placeholder="% Crédito presumido">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercEfetivo">Percentual efetivo</label>
                              <div class="input-group">
                                <input type="text" value="0.00" class="input-default focus form-control" id="txtPercEfetivo" name="txtPercEfetivo" class="form-control" placeholder="Percentual efetivo">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercRedBase">Perc. reduzido base ST</label>
                              <div class="input-group">
                                <input type="text" value="0.00" class="input-default focus form-control" id="txtPercRedBase" name="txtPercRedBase" class="form-control" placeholder="Percentual reduzido base ST">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtContabilizacao">Contabilização</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtContabilizacao" name="txtContabilizacao" class="form-control" placeholder="Contabilização">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnContabilizacao" name="btnContabilizacao" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnAContabilizacao" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-12  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="txtMensagem">Mensagem</label>
                              <div class="input-group">
                                <textarea style="resize: none" id="txtMensagem" maxlength="1000" placeholder="Mensagem" class="input-default focus form-control" rows="4"></textarea>
                              </div>
                            </div>

                          </div>
                        </div>
                        <input type="button" name="btnGravar" class="action-button" value="Gravar" id="btnGravar" />
                        <input type="button" name="voltar2" class="previous action-button-previous" value="Voltar" id="voltar2" />
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>
  <div class="modal fade" id="modalPISCOFINS" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Alterar PIS/COFINS</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-9  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstPIS">CST PIS</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCstPIS" name="txtCstPIS" class="form-control" placeholder="CST PIS">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCstPIS" name="btnCstPIS" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACstPIS" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliquotaPIS">Alíquota</label>
                  <div class="input-group">
                    <input type="text" value="0.00" class="input-default focus form-control" id="txtAliquotaPIS" name="txtAliquotaPIS" class="form-control" placeholder="Alíquota">
                  </div>
                </div>

                <div class="col-lg-9  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstCOFINS">CST COFINS</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCstCOFINS" name="txtCstCOFINS" class="form-control" placeholder="CST COFINS">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCstCOFINS" name="btnCstCOFINS" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACstCOFINS" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliquotaCOFINS">Alíquota</label>
                  <div class="input-group">
                    <input type="text" value="0.00" class="input-default focus form-control" id="txtAliquotaCOFINS" name="txtAliquotaCOFINS" class="form-control" placeholder="Alíquota">
                  </div>
                </div>

                <div class="col-lg-12  col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="configpiscofins">Configuração do valor de base (somar)</label>
                  <div class="row form-group checkboxMoeda" id="configpiscofins" style="margin-left: 0%; margin-right: 0%">
                    <div class="col-lg-6">
                      <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkFretePISCOFINS"><label class="labelCheck" for="checkFretePISCOFINS"> Frete</label></div>
                    </div>
                    <div class="col-lg-6">
                      <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkDespesaPISCOFINS"><label class="labelCheck" for="checkDespesaPISCOFINS">Despesa</label></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarPISCOFINS" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalIVA" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Alterar IVA</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <div class="row">
                
                <div class="col-lg-6  col-6 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliquotaIVA">Alíquota</label>
                  <div class="input-group">
                    <input type="text" value="0.00" class="input-default focus form-control" id="txtAliquotaIVA" name="txtAliquotaIVA" class="form-control" placeholder="Alíquota">
                  </div>
                </div>

                <div class="col-lg-6  col-6 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercIsentoIva">% Isento</label>
                  <div class="input-group">
                    <input type="text" value="0.00" class="input-default focus form-control" id="txtPercIsentoIva" name="txtPercIsentoIva" class="form-control" placeholder="% Isento">
                  </div>
                </div>

              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarIVA" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalIPI" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Alterar IPI</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-4  col-4" style="margin-top: 1%;">
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkUsarAliquotaNCM"><label class="labelCheck" for="checkUsarAliquotaNCM">Usar alíquota do NCM</label></div>
                </div>
                <div class="col-lg-9  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIpi">CST IPI</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCstIpi" name="txtCstIpi" class="form-control" placeholder="CST IPI">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCstIpi" name="btnCstIpi" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACstIpi" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliquotaIPI">Alíquota</label>
                  <div class="input-group">
                    <input type="text" value="0.00" class="input-default focus form-control" id="txtAliquotaIPI" name="txtAliquotaIPI" class="form-control" placeholder="Alíquota">
                  </div>
                </div>
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtEnquadraIPI">Enquadramento IPI</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtEnquadraIPI" name="txtEnquadraIPI" class="form-control" placeholder="Enquadramento IPI">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnEnquadraIPI" name="btnEnquadraIPI" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnAEnquadraIPI" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12  col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="configipi">Configuração do valor de base (somar)</label>
                  <div class="row form-group checkboxMoeda" id="configipi" style="margin-left: 0%; margin-right: 0%">
                    <div class="col-lg-4">
                      <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkFreteIPI"><label class="labelCheck" for="checkFreteIPI">Frete</label></div>
                    </div>
                    <div class="col-lg-4">
                      <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkDespesaIPI"><label class="labelCheck" for="checkDespesaIPI"> Despesa</label></div>
                    </div>
                    <div class="col-lg-4">
                      <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkSeguroIPI"><label class="labelCheck" for="checkSeguroIPI"> Seguro</label></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarIPI" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalICMS" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Alterar ICMS</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-3  col-3" style="margin-top: 1%;">
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkUsarAliquotaUF"><label class="labelCheck" for="checkUsarAliquotaUF">Usar alíquota da UF</label></div>
                </div>
                <div class="col-lg-3  col-3" style="margin-top: 1%;">
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkUsarCstItem"><label class="labelCheck" for="checkUsarCstItem">Usar CST do item</label></div>
                </div>
                <div class="col-lg-6  col-6" style="margin-top: 1%;">
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="descAliqEmp"><label class="labelCheck" for="descAliqEmp">Desconsiderar Alíquota Empresa</label></div>
                </div>
                <div class="col-lg-9  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtNaturezaICMS">Natureza</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtNaturezaICMS" name="txtNaturezaICMS" class="form-control" placeholder="Natureza">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnNaturezaICMS" name="btnNaturezaICMS" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnANaturezaICMS" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliquotaICMS">Alíquota</label>
                  <div class="input-group">
                    <input type="text" value="0.00" class="input-default focus form-control" id="txtAliquotaICMS" name="txtAliquotaICMS" class="form-control" placeholder="Alíquota">
                  </div>
                </div>
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtClatribICMS">Classificação tributária</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtClatribICMS" name="txtClatribICMS" class="form-control" placeholder="Classificação tributária">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnClatribICMS" name="btnClatribICMS" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnAClatribICMS" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-4  col-4 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCsosnICMS">CSOSN</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCsosnICMS" name="txtCsosnICMS" class="form-control" placeholder="CSOSN">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCsosnICMS" name="btnCsosnICMS" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACsosnICMS" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-4 col-4 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercReducaoCST">% Redução CST 10, 20, 70 e 90</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtPercReducaoCST" value="0.00" min="0" max="99" name="" class="form-control" placeholder="Percentual Redução CST .ICMS 10, 20, 70 e 90">
                  </div>
                </div>

                <div class="col-lg-4 col-4 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercIcmsDif">% Diferimento</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtPercIcmsDif" value="0.00" min="0" max="99" name="" class="form-control" placeholder="% Diferimento">
                  </div>
                </div>

                <div class="col-lg-4  col-4 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodBenef">Cód. benef. fiscal</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCodBenef" name="txtCodBenef" class="form-control" placeholder="Cód. benef. fiscal">
                  </div>
                </div>

                <div class="col-lg-4  col-4 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodBenef1">Cód. benef. fiscal 1</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCodBenef1" name="txtCodBenef1" class="form-control" placeholder="Cód. benef. fiscal 1">
                  </div>
                </div>

                <div class="col-lg-4  col-4 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodBenef2">Cód. benef. fiscal 2</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCodBenef2" name="txtCodBenef2" class="form-control" placeholder="Cód. benef. fiscal 2">
                  </div>
                </div>

                <div class="col-lg-4 col-4 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercCredPres">% Crédito presumido</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtPercCredPres" value="0.00" min="0" max="100" name="" class="form-control" placeholder="% Crédito presumido">
                  </div>
                </div>

                <div class="col-lg-4 col-4 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodBenefCred">Cód. benef. crédito</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtCodBenefCred" class="form-control" placeholder="Cód. benef. crédito">
                  </div>
                </div>

                <div class="col-lg-4 col-4 form-group input-group">
                  <label data-error="wrong" data-success="right" for="selectMotDeson">Motivo desoneração</label>
                  <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="selectMotDeson" class="custom-select focus">
                    <option value="0" selected>Nenhum</option>
                    <option value="1">Táxi</option>
                    <option value="3">Produtor agropecuário</option>
                    <option value="4">Frotista/Locadora</option>
                    <option value="5">Diplomático/Consular</option>
                    <option value="6">Utilitários e Motocicletas da Amazônia Ocidental e Áreas de Livre Comércio</option>
                    <option value="7">SUFRAMA</option>
                    <option value="8">Venda a Órgão Público</option>
                    <option value="9">Outros</option>
                    <option value="10">Deficiente Condutor</option>
                    <option value="11">Deficiente Não Conduto</option>
                    <option value="12">Órgão de fomento e Desenvolvimento Regional</option>
                    <option value="16">Olimpíadas Rio 2016</option>
                    <option value="90">Outros (usado quando não se encaixa nos demais)</option>
                    </option>
                  </select>
                </div>

                <div class="col-lg-12  col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="configICMS">Configuração do valor de base (somar)</label>
                  <div class="row form-group checkboxMoeda" id="configICMS" style="margin-left: 0%; margin-right: 0%">
                    <div class="col-lg-3">
                      <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkIpiIcms"><label class="labelCheck" for="checkIpiIcms">IPI</label></div>
                    </div>
                    <div class="col-lg-3">
                      <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkDespesaICMS"><label class="labelCheck" for="checkDespesaICMS">Despesa</label></div>
                    </div>
                    <div class="col-lg-3">
                      <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkSeguroICMS"><label class="labelCheck" for="checkSeguroICMS">Seguro</label></div>
                    </div>
                    <div class="col-lg-3">
                      <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkFreteICMS"><label class="labelCheck" for="checkFreteICMS">Frete</label></div>
                    </div>
                  </div>
                </div>

              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarICMS" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalCFOP" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar CFOP</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <table id="tabelaCFOP" class="table table-sm table-select table-hover">
                <thead>
                  <tr>
                    <th class="th-sm">CFOP</th>
                    <th class="th-sm">Descrição</th>
                    <th class="th-sm">Ações</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCFOP">CFOP</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCFOP" name="txtCFOP" class="form-control" placeholder="CFOP">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnbuscaCFOP" name="btnbuscaCFOP" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACFOP" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12 form-group">
                  <button class="btn bg-danger btn-block" id="btnAdicionarCFOP" name="btnAdicionarCFOP" data-button="absolute" type="button">
                    <label class="m-0 p-0">Adicionar</label>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarCFOP" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalModelo" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Modelo</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <table id="tabelaModelo" class="table table-sm table-select table-hover">
                <thead>
                  <tr>
                    <th class="th-sm">Modelo</th>
                    <th class="th-sm">Descrição</th>
                    <th class="th-sm">Ações</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtModelo">Modelo</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtModelo" name="txtModelo" class="form-control" placeholder="Modelo">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnbuscaModelo" name="btnbuscaModelo" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnAModelo" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12 form-group">
                  <button class="btn bg-danger btn-block" id="btnAdicionarModelo" name="btnAdicionarModelo" data-button="absolute" type="button">
                    <label class="m-0 p-0">Adicionar</label>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarModelo" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalCodSPED" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Código SPED</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <table id="tabelaCodSPED" class="table table-sm table-select table-hover">
                <thead>
                  <tr>
                    <th class="th-sm">Cod. SPED</th>
                    <th class="th-sm">Descrição</th>
                    <th class="th-sm">Ações</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodSPED">Código SPED</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCodSPED" name="txtCodSPED" class="form-control" placeholder="CodSPED">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnbuscaCodSPED" name="btnbuscaCodSPED" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACodSPED" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12 form-group">
                  <button class="btn bg-danger btn-block" id="btnAdicionarCodSPED" name="btnAdicionarCodSPED" data-button="absolute" type="button">
                    <label class="m-0 p-0">Adicionar</label>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarCodSPED" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalEntidAux" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Entid. Aux</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <table id="tabelaEntidAux" class="table table-sm table-select table-hover">
                <thead>
                  <tr>
                    <th class="th-sm">Entid. Aux</th>
                    <th class="th-sm">Descrição</th>
                    <th class="th-sm">Ações</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtEntidAux">Entid. Aux</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtEntidAux" name="txtEntidAux" class="form-control" placeholder="EntidAux">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnbuscaEntidAux" name="btnbuscaEntidAux" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnAEntidAux" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12 form-group">
                  <button class="btn bg-danger btn-block" id="btnAdicionarEntidAux" name="btnAdicionarEntidAux" data-button="absolute" type="button">
                    <label class="m-0 p-0">Adicionar</label>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarEntidAux" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalNCM" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar NCM</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <table id="tabelaNCM" class="table table-sm table-select table-hover">
                <thead>
                  <tr>
                    <th class="th-sm">NCM</th>
                    <th class="th-sm">Descrição</th>
                    <th class="th-sm">Ações</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtNCM">NCM</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtNCM" name="txtNCM" class="form-control" placeholder="NCM">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnbuscaNCM" name="btnbuscaNCM" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnANCM" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12 form-group">
                  <button class="btn bg-danger btn-block" id="btnAdicionarNCM" name="btnAdicionarNCM" data-button="absolute" type="button">
                    <label class="m-0 p-0">Adicionar</label>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarNCM" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalEstados" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Estados</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group" style="margin-left: 5%;">
            <div class="col-lg-2">
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkAC"><label class="labelCheck" for="checkAC">AC</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkAL"><label class="labelCheck" for="checkAL">AL</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkAM"><label class="labelCheck" for="checkAM">AM</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkAP"><label class="labelCheck" for="checkAP">AP</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkBA"><label class="labelCheck" for="checkBA">BA</label></div>
            </div>
            <div class="col-lg-2">
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkCE"><label class="labelCheck" for="checkCE">CE</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkDF"><label class="labelCheck" for="checkDF">DF</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkES"><label class="labelCheck" for="checkES">ES</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkEX"><label class="labelCheck" for="checkEX">EX</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkGO"><label class="labelCheck" for="checkGO">GO</label></div>
            </div>
            <div class="col-lg-2">
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkMA"><label class="labelCheck" for="checkMA">MA</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkMG"><label class="labelCheck" for="checkMG">MG</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkMS"><label class="labelCheck" for="checkMS">MS</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkMT"><label class="labelCheck" for="checkMT">MT</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkPA"><label class="labelCheck" for="checkPA">PA</label></div>
            </div>
            <div class="col-lg-2">
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkPB"><label class="labelCheck" for="checkPB">PB</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkPE"><label class="labelCheck" for="checkPE">PE</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkPI"><label class="labelCheck" for="checkPI">PI</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkPR"><label class="labelCheck" for="checkPR">PR</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkRJ"><label class="labelCheck" for="checkRJ">RJ</label></div>
            </div>
            <div class="col-lg-2">
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkRN"><label class="labelCheck" for="checkRN">RN</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkRO"><label class="labelCheck" for="checkRO">RO</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkRR"><label class="labelCheck" for="checkRR">RR</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkRS"><label class="labelCheck" for="checkRS">RS</label></div>
            </div>
            <div class="col-lg-2">
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkSC"><label class="labelCheck" for="checkSC">SC</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkSE"><label class="labelCheck" for="checkSE">SE</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkSP"><label class="labelCheck" for="checkSP">SP</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkTO"><label class="labelCheck" for="checkTO">TO</label></div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarEstados" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalEntidade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Tributação da Entidade</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group" style="margin-left: 5%;">
            <div class="col-lg-6 mx-auto">
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkA"><label class="labelCheck" for="checkA">A - Normal s/ Substituição</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkN"><label class="labelCheck" for="checkN">N - Normal c/ Substituição - Regime Normal</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkL"><label class="labelCheck" for="checkL">L - Normal c/ Substituição - Simples Nacional</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkD"><label class="labelCheck" for="checkD">D - Diferenciada c/ Substituição</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkS"><label class="labelCheck" for="checkS">S - Simples</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkR"><label class="labelCheck" for="checkR">R - Simples s/ Inscrição Estatual</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkC"><label class="labelCheck" for="checkC">C - Carga Média</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkP"><label class="labelCheck" for="checkP">P - Substituição com Alíq.Simples</label></div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarEntidade" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalOrigem" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Origem do Item</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group" style="margin-left: 5%;">
            <div class="col-lg-12">
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkNormalOrig"><label class="labelCheck" for="checkNormalOrig">N - Normal</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkDiferenciada"><label class="labelCheck" for="checkDiferenciada">D - Diferenciada</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="check1"><label class="labelCheck" for="check1">1 - Produto Importado</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="check2"><label class="labelCheck" for="check2">2 - Produto Importado Mercado Interno</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="check3"><label class="labelCheck" for="check3">3 - Conteúdo de importação maior 40% e inferior ou igual 70%</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="check4"><label class="labelCheck" for="check4">4 - Conformidade Processos básicos</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="check5"> <label class="labelCheck" for="check5">5 - Conteúdo de importação menor ou igual 40%</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="check6"><label class="labelCheck" for="check6">6 - Prod. Importdado sem similar nacional</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="check7"><label class="labelCheck" for="check7">7 - Adquirido merc. interno sem similar nacional</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="check8"><label class="labelCheck" for="check8">8 - Conteúdo de importação superior 70%</label></div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarOrigem" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalPresenca" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Presença</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group" style="margin-left: 5%;">
            <div class="col-lg-6 mx-auto">
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="chkPresenca0"><label class="labelCheck" for="chkPresenca0">0 - Não se aplica (por exemplo, Nota Fiscal complementar ou de ajuste)</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="chkPresenca1"><label class="labelCheck" for="chkPresenca1">1 - Operação presencial</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="chkPresenca2"><label class="labelCheck" for="chkPresenca2">2 - Operação não presencial, pela Internet</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="chkPresenca3"><label class="labelCheck" for="chkPresenca3">3 - Operação não presencial, Teleatendimento</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="chkPresenca4"><label class="labelCheck" for="chkPresenca4">4 - NFC-e em operação com entrega a domicílio</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="chkPresenca5"><label class="labelCheck" for="chkPresenca5">5 - Operação presencial, fora do estabelecimento</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="chkPresenca9"><label class="labelCheck" for="chkPresenca9">9 - Operação não presencial, outros</label></div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarPresenca" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalIndIE" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Indicador da IE do Destinatário</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-4 mx-auto">
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="chkIndIE1"><label class="labelCheck" for="chkIndIE1">1 - Contribuinte ICMS</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="chkIndIE2"><label class="labelCheck" for="chkIndIE2">2 - Contribuinte isento</label></div>
              <div class="icheck-primary"><input type="checkbox" class="configCheck" id="chkIndIE9"><label class="labelCheck" for="chkIndIE9">9 - Não contribuinte</label></div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarIndIE" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../../modais.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.257.10.1"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.257.10.1"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.257.10.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.257.10.1"></script>

  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.257.10.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.257.10.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.257.10.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.257.10.1"></script>
  <script src="../utils/funcoes.js?versao=3.257.10.1"></script>
  <script src="../dist/js/jquery.inputmask.js"></script>
  <script src="../utils/cookies.js?versao=3.257.10.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/jquery.mask.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/dataTables.keyTable2.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.257.10.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('REGRAFISCAL');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("REGRAFISCAL");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/regrafiscal`
        });
        return;
      }

      sArquivo = `${BASE_URI}/pages/reducao/cadastro_reducao/reducao.js?versao=3.257.10.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>