$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#txtDeposito",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "bottom",
        },
      },
      {
        element: "#txtData",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "bottom",
        },
      },
      {
        element: "#txtQualidade",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtSetor",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtQuantidade",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#tipos",
        popover: {
          title: "Tipo de Barra",
          description: "Aqui você define qual tipo de barra quer utilizar.",
          position: "bottom",
        },
      },
      {
        element: "#opcoes",
        popover: {
          title: "Opções",
          description: "Aqui você pode selecionar algumas opções.",
          position: "top",
        },
      },
      {
        element: "#tabelaGerarInventarioLoja",
        popover: {
          title: "Tabela Inventário",
          description: "Aqui ficam todos os dados dos itens que forem bipados.",
          position: "top",
        },
      },
      {
        element: "#btnCancelar",
        popover: {
          title: "Botão Cancelar",
          description:
            "Ao clicar nesse botão você cancela todos os itens passados.",
          position: "top",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gerar",
          description: "Clique aqui para gerar o inventário.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let listaBarrasBipadas = [];
  const parametrosSistema = await BuscaParametrosSistema();
  const utilizaBarraLog = parametrosSistema[0].VALOR != 0;

  let contador1 = 0;
  let contador2 = 0;
  let contador3 = 0;
  let contador4 = 0;
  let contador5 = 0;



  await setarDataAtual("txtData");

  $('.somAtivo').on('click', function () {
    $(this).addClass('d-none');
    localStorage.setItem("@inventario.somAtivo", false);
    $('.somInativo').removeClass('d-none');
  });

  $('.somInativo').on('click', function () {
    $(this).addClass('d-none');
    localStorage.setItem("@inventario.somAtivo", true);
    $('.somAtivo').removeClass('d-none');
  });

  const somAtivo = localStorage.getItem('@inventario.somAtivo') ?? 'false';
  if (somAtivo == 'true') {
    $($('.somInativo')[0]).trigger('click');
  }

  let tabelaGrade = $("#tabela-grade").DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    autoWidth: true,
    destroy: true,
  });

  const depositoUsuario = await retornaDepositoUsuario(getCookie('cod_usuario'));

  if (depositoUsuario != 'null') {
    $("#txtDeposito").autocompleta(
      1,
      `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ${depositoUsuario}}`
    );

  } else {
    $("#txtDeposito").autocompleta(
      1,
      'JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}'
    );
  }
  $("#txtQualidade").autocompleta(
    1,
    'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}'
  );
  $("#txtSetor").autocompleta(
    1,
    'JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}'
  );

  $("#txtProduto").autocompleta(
    2,
    `JSON={ "tabela":"produto", "camposSelect":["CODIGO CHAVE, DESCRICAO, CUSTO"], "where": [] }`,
    ["#txtPrecoSped"],
    ["CUSTO"],
    ["CUSTO"],
    filtraGrade,
    [true]
  );

  if (depositoUsuario != 'null') {
    $("#btn-Deposito").pesquisa(
      "#txtDeposito",
      "CODIGO",
      "DESCRICAO",
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${depositoUsuario}}`,
      "Pesquisa Deposito",
      "DEPOSITO"
    );
  } else {
    $("#btn-Deposito").pesquisa(
      "#txtDeposito",
      "CODIGO",
      "DESCRICAO",
      '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}',
      "Pesquisa Deposito",
      "DEPOSITO"
    );
  }
  $("#btn-Qualidade").pesquisa(
    "#txtQualidade",
    "CODIGO",
    "DESCRICAO",
    '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO"]}',
    "Pesquisa Qualidade",
    "TABQUL"
  );
  $("#btn-Setor").pesquisa(
    "#txtSetor",
    "CODIGO",
    "DESCRICAO",
    '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}',
    "Pesquisa Setor",
    "CADFLUXO"
  );

  $("#btn-Produto").pesquisa_serverside(
    ["#txtProduto"],
    ["CODIGO", "DESCRICAO", "CODIGO2"],
    ["DESCRICAO", "CODIGO", "CODIGO2"],
    '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2" ], "where": null}',
    "Pesquisa de Produto"
  );
  $("#btnCor").pesquisa_array(
    ["#txtCor"],
    ["COR"],
    ["DESCRICAO"],
    '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcor", "camposSelect":[ "cor", "descricao" ], "where": null}',
    "Pesquisa Cor",
    "cadcor",
    filtraGrade
  );

  $("#btn-limpa-Deposito").on("click", function () {
    $("#txtDeposito").val("");
  });
  $("#btn-limpa-Qualidade").on("click", function () {
    $("#txtQualidade").val("");
  });
  $("#btn-limpa-Setor").on("click", function () {
    $("#txtSetor").val("");
  });
  $("#btn-limpa-Produto").on("click", function () {
    $("#txtProduto").val("");
  });
  $("#btnLimpaCor").on("click", function () {
    $("#txtCor").val("");
  });

  $("#txtProduto").on("blur", function () {
    $("#txtCor").unbind("autocompleta");
    $("#txtCor").autocompleta(
      1,
      `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${$(
        this
      ).attr("data-chave")}'"] }`,
      [],
      [],
      [],
      filtraGrade
    );
    $("#btnCor").off();
    $("#btnCor").unbind("pesquisa_array");
    $("#btnCor").pesquisa_array(
      ["#txtCor"],
      ["COR"],
      ["DESCRICAO"],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"pa_iten", "camposSelect":[ "pa_iten.cor", "cadcor.descricao" ],"leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_Iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$(
        this
      ).attr("data-chave")}'"]}`,
      "Pesquisa Cor",
      "cadcor",
      filtraGrade
    );
  });

  let inputBarras = $(".barras");
  inputBarras.on("click", function () {
    inputBarras.get().forEach(function (ev) {
      let event = ev;
      event.checked = ev == this && this.checked;
    }, this);
  });

  $("#tabelaGerarInventarioLoja").DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    autoWidth: false,
    destroy: true,
    scrollY: "300px",

    columnDefs: [
      {
        targets: [12, 13, 14],
        visible: false,
      },
      {
        "targets": [1],
        "className": 'pr-4 text-right'
      }
    ],
  });

  $('#txtQuantidadeBipada').val(0);

  $("#tabelaGerarInventarioLoja tbody").on("click", "tr", async function () {
    $("#tabelaGerarInventarioLoja tbody tr td")[0].click();
    $("#tabelaGerarInventarioLoja tbody tr.selected").removeClass("selected");
    $(this).addClass("selected");
  });

  $("#checkTodos").attr("checked", true);
  $("#txtQuantidade").val(1);
  $("#txtQualidade").val("[1] - PRIMEIRA");

  $("#btnGravar").on("click", async function () {
    try {
      $('#btnGravar').prop('disabled', true);
      $.LoadingOverlay("show");
      try {
        if ($("#txtDeposito").val() == "") {
          msgAlerta("Depósito não informado, favor verificar.");
          return;
        }

        if ($("#txtQualidade").val() == "") {
          msgAlerta("Qualidade não informada, favor verificar.");
          return;
        }

        if ($("#txtSetor").val() == "") {
          msgAlerta("Setor não informado, favor verificar.");
          return;
        }

        if ($("#txtQuantidade").val() == "") {
          msgAlerta("Quantidade não informada, favor verificar.");
          return;
        }

        if ($("#txtData").val() == "") {
          msgAlerta("Data não informada ou inválida.");
          return;
        }

        if ($("#tabelaGerarInventarioLoja").DataTable().rows().count() == 0) {
          msgAlerta("Nenhum registro para ser gravado, favor verificar.");
          return;
        }

        for (
          let i = 0;
          i < $("#tabelaGerarInventarioLoja").DataTable().rows().count();
          i++
        ) {
          const dados = $("#tabelaGerarInventarioLoja")
            .DataTable()
            .row(i)
            .data();
          const dadosValidacao = dados[1];
          const saoIguais = dadosValidacao === 0;
          if (saoIguais) {
            $("#tabelaGerarInventarioLoja")
              .DataTable()
              .row(i)
              .data(dados)
              .remove()
              .draw(false);
          }
        }

        let objetoInventario = await preencheJson();

        const barraslog = {
          barras: utilizaBarraLog ? listaBarrasBipadas : []
        };

        const response = await requisicao(
          "POST",
          "/sisplan/inventario/v1/inventario?",
          '',
          `JSON=${encodeURIComponent(JSON.stringify(objetoInventario))}&JSONBARRAS=${encodeURIComponent(JSON.stringify(barraslog))}`,
          900000
        );
        if (!response) {
          return;
        }

        if (response.status != 200) {
          const jsonInventario = await response.json();
          msgErro(jsonInventario.mensagem);
          return;
        }
        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.reload();
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
      }
      await deletaArquivo("JsonInventarioProduto");
    } finally {
      $('#btnGravar').prop('disabled', false);
      $.LoadingOverlay("hide");
    }
  });

  function limpaCampos() {
    $("#tabelaGerarInventarioLoja").DataTable().clear().draw(false);
    $("#txtDeposito").val("");
    $("#txtQualidade").val("[1] - PRIMEIRA");
    $("#txtSetor").val("");
    $("#txtQuantidade").val(1);
    if (
      $("#checkEan13").prop("checked") ||
      $("#checkBarra28").prop("checked") ||
      $("#checkBarraCli").prop("checked")
    ) {
      $("#checkTodos").attr("checked", true);
    }
    $("#tabela-grade").DataTable().rows().remove().draw(false);
    $("#txtQuantidadeBipada").val(0);
    listaBarrasBipadas = [];
  }

  $("#btnCancelar").on("click", async function () {
    msgAlerta("Deseja realmente cancelar os itens passados?", () => { cancelaItens(), deletaArquivo("JsonInventarioProduto") });
  });

  async function cancelaItens() {
    limpaCampos();

    const data = new Date();
    await rotinaGeraLog('INVENTARIO PRODUTO', data.toLocaleDateString(), 'INVENTARIO CANCELADO PRODUTO- BOTAO CANCELAR SELECIONADO', 'Exclusão');
  }

  async function LocalizaBarraGrid() {
    const barraBipada = $("#txtCodigo").val();
    await BarraEncontrada(barraBipada);
  }

  async function BarraEncontrada(barraBipada) {
    if (barraBipada != "") {
      const dados = $("#tabelaGerarInventarioLoja")
        .DataTable()
        .rows()
        .data()
        .toArray();
      const indiceEncontrado = dados.findIndex(
        (item) => (item[8] == barraBipada || item[11] == barraBipada) && item[9] == pegaChave('#txtQualidade')
      );
      if (indiceEncontrado !== -1) {
        const dadosItem = $("#tabelaGerarInventarioLoja")
          .DataTable()
          .row(indiceEncontrado)
          .data();

        $("#tabelaGerarInventarioLoja")
          .DataTable()
          .row(indiceEncontrado)
          .data(dadosItem)
          .draw(false);
        $($("#tabelaGerarInventarioLoja tbody tr")[indiceEncontrado]).click();
        $(".dataTables_scrollBody").scrollTo(
          $("#tabelaGerarInventarioLoja tbody tr").eq(indiceEncontrado),
          200
        );
      } else {

      }
    }

    const jsonarquivo = montaJsonArquivo();
    await salvaArquivo("JsonInventarioProduto", jsonarquivo);
  }

  $('#btnMenosOuMais').on('click', function () {
    const estaComoEstorno = $('#btnMenosOuMais>i.fa-minus').length > 0;
    $('#labelBarras').html(estaComoEstorno ? 'Barra' : 'Barra Estorno');
    $('#txtCodigo').attr('placeholder', estaComoEstorno ? 'Barra' : 'Barra Estorno');
    $('#txtCodigo').focus();
    $('#btnMenosOuMais').attr('data-estorno', !estaComoEstorno);
    if (estaComoEstorno) {
      $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
    } else { $('#btnMenosOuMais>i.fa-plus').removeClass('fa-plus').addClass('fa-minus'); }
  });

  $("#txtCodigo").on("blur", async function () {
    if ($("#txtCodigo").val() != "") {
      if ($("#txtQuantidade").val() != "") {
        if ($("#txtQuantidade").val() === "0") {
          msgAlerta(
            "Quantidade não informada ou igual a zero. Impossível Continuar!"
          );
          SomAlerta(BASE_URI, true);
        } else {
          await iniciaInventario();
          await LocalizaBarraGrid();
          await VerificaQuantidade();
          $("#txtCodigo").val("");
          $("#txtCodigo").focus();
          return;
        }
      }
      msgAlerta(
        "Quantidade não informada ou igual a zero. Impossível Continuar!"
      );
      SomAlerta(BASE_URI, true);
    }
  });

  $("#btnAddCondicao").on("keypress", function () {
    $("#btnAddCondicao").trigger("click");
  });

  // $("#txtCodigo").on("change", async function () {
  //   $("#txtCodigo").focus();
  // });

  let errosInventario = [];

  async function iniciaIventarioImportacao() {
    try {
      $.LoadingOverlay("show");
      try {
        const url = "/sisplan/inventario/v1/validacodigoinventario?";

        const objetoInventario = await preencheObjetoInventario();

        const response = await requisicao(
          "GET",
          url,
          `JSON=${encodeURIComponent(JSON.stringify(objetoInventario))}`
        );

        if (!response) {
          return;
        }
        const jsonInventario = await response.json();
        if (response.status != 200) {
          errosInventario.push(jsonInventario.mensagem); // Adiciona o erro à lista
          SomAlerta(BASE_URI, true);
          return;
        }

        const { codigo } = jsonInventario;
        const { cor } = jsonInventario;
        const tam = jsonInventario.tamanho;

        const responseBarra = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.CODIGO", "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.COR", "PA_ITEN.TAM", "PRODUTO.UNIDADE", "PRODUTO.PRECO", "PRODUTO.POSSE"],
        "leftjoin": [{"tabela" : "PRODUTO", "condicao" : "PRODUTO.CODIGO = PA_ITEN.CODIGO"}], 
        "where":["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.COR = '${cor}' AND PA_ITEN.TAM = '${tam}'"]}`,
          null
        );

        if (!responseBarra) {
          return;
        }
        const jsonBarra = await responseBarra.json();
        if (responseBarra.status != 200) {
          errosInventario.push(jsonBarra.mensagem);
          SomAlerta(BASE_URI, true);
          return;
        }

        const jsonTodasBarras = jsonBarra.RESULT[0];
        const barraNormal = jsonTodasBarras[0].BARRA;
        jsonInventario.barraNormal = barraNormal;
        jsonInventario.posse = jsonTodasBarras[0].POSSE;

        await preencheObjetoLinhaNova([jsonInventario]);

      } catch (error) {
        errosInventario.push("Erro ao buscar item."); // Adiciona erro ao buscar item à lista
        SomAlerta(BASE_URI, true);
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function iniciaInventario() {
    try {
      $.LoadingOverlay("show");
      try {
        const url = "/sisplan/inventario/v1/validacodigoinventario?";

        const objetoInventario = await preencheObjetoInventario();

        const response = await requisicao(
          "GET",
          url,
          `JSON=${encodeURIComponent(JSON.stringify(objetoInventario))}`
        );

        if (!response) {
          return;
        }
        const jsonInventario = await response.json();
        if (response.status != 200) {
          msgErro(jsonInventario.mensagem);
          SomAlerta(BASE_URI, true);
          return;
        }

        const { codigo } = jsonInventario;
        const { cor } = jsonInventario;
        const tam = jsonInventario.tamanho;

        const pesquisaBarra = `{ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.CODIGO", "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.COR", "PA_ITEN.TAM", "PRODUTO.UNIDADE", "PRODUTO.PRECO", "PRODUTO.POSSE"], "leftjoin": [{"tabela" : "PRODUTO", "condicao" : "PRODUTO.CODIGO = PA_ITEN.CODIGO"}], "where":["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.COR = '${cor}' AND PA_ITEN.TAM = '${tam}'"]}`;

        const responseBarra = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON=${encodeURIComponent(pesquisaBarra)}`,
          null
        );

        if (!responseBarra) {
          return;
        }
        const jsonBarra = await responseBarra.json();
        if (responseBarra.status != 200) {
          msgErro(jsonBarra.mensagem);
          SomAlerta(BASE_URI, true);
          return;
        }

        const jsonTodasBarras = jsonBarra.RESULT[0];
        const barraNormal = jsonTodasBarras[0].BARRA;
        jsonInventario.barraNormal = barraNormal;
        jsonInventario.posse = jsonTodasBarras[0].POSSE;

        await preencheObjetoLinhaNova([jsonInventario]);

      } catch (error) {
        SomAlerta(BASE_URI, true);
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function adicionaBarraBipada(objItem) {
    try {
      const retornoBarraLog = await retornaBarraLogLida(objItem.barra);
      if (['barra_log'].includes(retornoBarraLog)) {
        listaBarrasBipadas.push(objItem);
        return true;
      } else {
        return false;
      }
    } catch (error) {
      console.error(error);
    }
  }

  async function retornaBarraLogLida(sBarra) {
    try {
      const url = `/sisplan/barralog/v1/validarbarra?`;
      const params = `barra=${encodeURIComponent(sBarra)}`;
      const response = await requisicao('GET', url, params, 15000);

      if (!response) {
        return;
      }

      jsonStr = await response.json();
      if (response.status != 200) {
        return jsonStr.mensagem;
      }

      return jsonStr.mensagem;
    } catch (error) {
      console.error(error);
    }
  }

  async function barraJaEstaBipada(sBarra) {
    try {
      if (listaBarrasBipadas.find(item => item.barra == sBarra)) {
        msgErro(`Barra ${sBarra} já lida, verifique.`);
        return true;
      }
      return false;
    } catch (error) {
      console.error('barra_log', error);
      msgErro('Erro ao processar barra log.');
      return false;
    }
  }

  async function barraJaEstornada(sBarra) {
    try {
      if (listaBarrasBipadas.find(item => item.barra == sBarra)) {
        return false;
      }
      return true;
    } catch (error) {
      console.error('barra_log', error);
      msgErro('Erro ao processar barra log.');
      return false;
    }
  }

  async function estornaBarraBipada(sBarra) {
    try {
      listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.barra !== sBarra)];
    } catch (error) {
      console.error(error);
    }
  }

  async function retornaDadosPorCodigoCorTamanho(Codigo, Cor, Tamanho) {
    const result = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.CODIGO", "PA_ITEN.BARRA", "PRODUTO.DESCRICAO", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.COR", "PA_ITEN.TAM", "PRODUTO.UNIDADE", "PRODUTO.PRECO", "PRODUTO.POSSE"],
    "leftjoin": [{"tabela" : "PRODUTO", "condicao" : "PRODUTO.CODIGO = PA_ITEN.CODIGO"}], 
    "where":["PA_ITEN.CODIGO = '${Codigo}' AND PA_ITEN.COR = '${Cor}' AND PA_ITEN.TAM = '${Tamanho}'"]}`,
      null
    );
    return result;
  }

  async function preencheObjetoLinhaNova(objeto) {
    const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno');
    const ehPrimeiroRegistro = $('#tabelaGerarInventarioLoja').DataTable().rows().data().toArray().length === 0;
    const ehbarralog = utilizaBarraLog ? await retornaBarraLogLida($('#txtCodigo').val()) == "barra_log" : false;

    if (estornaQuantidade == "true" && ehPrimeiroRegistro == true) {
      msgAlerta("Nenhuma barra para estornar!");
      SomAlerta(BASE_URI, true);
      return;
    }


    try {
      const qtdeLinhas = $("#tabelaGerarInventarioLoja")
        .DataTable()
        .rows()
        .count();

      let validaQtde = 0;

      if (utilizaBarraLog && ehbarralog && $("#txtQuantidade").val() > 1) {
        msgAlerta("Quantidade inválida. Permitido bipar somente uma quantidade na barra log.");
        SomAlerta(BASE_URI, true);
        return;
      }
      if (estornaQuantidade == 'false') {
        validaQtde = objeto[0].quantidade;
      } else {
        validaQtde = objeto[0].quantidade * -1;
      }


      const barraEstornada = utilizaBarraLog ? await barraJaEstornada($('#txtCodigo').val()) : false;

      if (utilizaBarraLog) {
        if (estornaQuantidade == 'true') {
          await estornaBarraBipada($('#txtCodigo').val());
        }
      }

      const barraBipada = utilizaBarraLog ? await barraJaEstaBipada($('#txtCodigo').val()) : false;


      if (barraBipada && ehbarralog) {
        return;
      }

      if (barraEstornada && estornaQuantidade == 'true' && ehbarralog) {
        msgErro(`Barra ${$('#txtCodigo').val()} já estornada, verifique.`);
        SomAlerta(BASE_URI, true);
        return;
      }

      if (utilizaBarraLog) {
        if (estornaQuantidade == 'false') {
          await adicionaBarraBipada(
            {
              codigo: objeto[0].codigo,
              cor: objeto[0].cor,
              tam: objeto[0].tamanho,
              barra: $('#txtCodigo').val(),
            }
          );
        }
      }
      const novaLinha = [
        objeto[0].codigo,
        validaQtde,
        objeto[0].descricao,
        objeto[0].deposito,
        objeto[0].lote,
        objeto[0].cor,
        objeto[0].descricaoCor,
        objeto[0].tamanho,
        objeto[0].barra,
        pegaChave('#txtQualidade'),
        objeto[0].codigo2,
        "",
        objeto[0].unidade,
        objeto[0].preco,
        objeto[0].posse,
      ];
      let sCodigoValidacao;
      if (utilizaBarraLog && ehbarralog) {
        sCodigoValidacao = `${novaLinha[0]} - ${novaLinha[5]} - ${novaLinha[7]} - ${novaLinha[8]}`;
      } else {
        sCodigoValidacao = `${novaLinha[0]} - ${novaLinha[5]} - ${novaLinha[7]} - ${novaLinha[9]}`;
      }
      if (qtdeLinhas > 0) {
        for (
          let i = 0;
          i < $("#tabelaGerarInventarioLoja").DataTable().rows().count();
          i++
        ) {
          const dados = $("#tabelaGerarInventarioLoja")
            .DataTable()
            .row(i)
            .data();
          let dadosValidacao;
          if (utilizaBarraLog && ehbarralog) {
            dadosValidacao = `${dados[0]} - ${dados[5]} - ${dados[7]} - ${dados[8]}`;
          } else {
            dadosValidacao = `${dados[0]} - ${dados[5]} - ${dados[7]} - ${dados[9]}`;
          }
          const saoIguais = dadosValidacao == sCodigoValidacao;
          if (saoIguais) {
            if (dados[1] > 0) {
              dados[1] += validaQtde;
              $("#tabelaGerarInventarioLoja").DataTable().row(i).data(dados);
              if (dados[1] <= 0) {
                $("#tabelaGerarInventarioLoja").DataTable().row(i).remove().draw();
              }
              SomAlerta();
              return;
            }
          }
        }
        if (novaLinha[1] < 0 && estornaQuantidade == "true") {
          msgAlerta("Sem quantidade para estornar!");
          SomAlerta(BASE_URI, true);
          return;
        }
        SomAlerta();
        $("#tabelaGerarInventarioLoja")
          .DataTable()
          .row.add(novaLinha)
          .draw(false);
        $("#ultimoCodigo").val(novaLinha[0]);
        return;
      }

      $("#tabelaGerarInventarioLoja")
        .DataTable()
        .row.add(novaLinha)
        .draw(false);
      $("#ultimoCodigo").val(novaLinha[0]);
      setTimeout(() => {
        SomAlerta();
      }, 300);
    } catch (error) {
      msgErro("Erro ao retornar a linha.");
      SomAlerta(BASE_URI, true);
    }
  }

  async function preencheJson() {
    let jsonInventario = [];

    for (
      let i = 0;
      i < $("#tabelaGerarInventarioLoja").DataTable().rows().count();
      i++
    ) {
      const dados = $("#tabelaGerarInventarioLoja").DataTable().row(i).data();

      let objetoInventario = {
        CODIGO: dados[0],
        COR: dados[5],
        DEPOSITO: dados[3],
        DESCRICAO: dados[2],
        DT_MES: `${$("#txtData").val()}T00:00:00Z`,
        SETOR: pegaDescricao($("#txtSetor").val()),
        TAMANHO: dados[7],
        UNIDADE: dados[12],
        LOTE: dados[4],
        CODSETOR: pegaChave($("#txtSetor").val()),
        PRECO: dados[13],
        BARRA: dados[8],
        QUALIDADE: dados[9],
        QTDE: dados[1],
        POSSE: dados[14],
      };

      jsonInventario.push(objetoInventario);
    }

    const retorno = {
      Inventarios: jsonInventario,
    };
    return retorno;
  }

  async function preencheObjetoInventario() {
    let objetoInventario = {};

    objetoInventario.CODIGO = $("#txtCodigo").val();
    objetoInventario.QUANTIDADE = $("#txtQuantidade").val();
    objetoInventario.DEPOSITO = pegaChave($("#txtDeposito").val());
    objetoInventario.QUALIDADE = pegaChave($("#txtQualidade").val());
    objetoInventario.SETOR = pegaChave($("#txtSetor").val());
    objetoInventario.DATA = `${$("#txtData").val()}T00:00:00Z`;
    objetoInventario.BARRA = $("#txtCodigo").val();

    switch ($("input[name=radioBarras]:checked").val()) {
      case "0":
        objetoInventario.TIPOBARRA = "0";
        break;
      case "1":
        objetoInventario.TIPOBARRA = "1";
        break;
      case "2":
        objetoInventario.TIPOBARRA = "2";
        break;
      case "3":
        objetoInventario.TIPOBARRA = "3";
        break;
      case "4":
        objetoInventario.TIPOBARRA = "4";
        break;
      default:
        break;
    }
    return objetoInventario;
  }

  try {
    const response = await carregaArquivo("JsonInventarioProduto");
    if (response.status === 200) {
      const jsonStr = await response.json();
      insereValor(
        "#txtDeposito",
        jsonStr.deposito.split("] - ")[0].substr(1),
        jsonStr.deposito.split("] - ")[1]
      );
      insereValor(
        "#txtQualidade",
        jsonStr.qualidade.split("] - ")[0].substr(1),
        jsonStr.qualidade.split("] - ")[1]
      );
      insereValor(
        "#txtSetor",
        jsonStr.setor.split("] - ")[0].substr(1),
        jsonStr.setor.split("] - ")[1]
      );
      insereValor("#txtData", jsonStr.data);
      jsonStr.itens.forEach((item) => {
        $("#tabelaGerarInventarioLoja")
          .DataTable()
          .row.add([
            item.codigo,
            item.quantidade,
            item.descricao,
            item.deposito,
            item.lote,
            item.cor,
            item.descor,
            item.tam,
            item.barra,
            item.qualidade,
            item.codigo2,
            item.barra28,
            item.unidade,
            item.preco,
            item.posse,
          ])
          .draw(false);
      });
      listaBarrasBipadas = jsonStr.barrasbipadas;
      await VerificaQuantidade();
      msgAlerta("Carregado dados não salvos, verifique.");
    }
  } catch (error) {
    console.log(error);
  }

  function montaJsonItens() {
    const itensDataTable = $("#tabelaGerarInventarioLoja")
      .DataTable()
      .data()
      .toArray();
    const itens = itensDataTable.map((itemDT) => {
      const item = {
        codigo: itemDT[0],
        quantidade: itemDT[1],
        descricao: itemDT[2],
        deposito: itemDT[3],
        lote: itemDT[4],
        cor: itemDT[5],
        descor: itemDT[6],
        tam: itemDT[7],
        barra: itemDT[8],
        qualidade: itemDT[9],
        codigo2: itemDT[10],
        barra28: itemDT[11],
        unidade: itemDT[12],
        preco: itemDT[13],
        posse: itemDT[14],
      };
      return item;
    });
    return itens;
  }

  async function filtraGrade() {
    if (
      $("#txtProduto").val() != "" &&
      $("#txtCor").val() != "" &&
      $("#txtCor").val().substr(0, 1) == "["
    ) {
      let dataSet = await RetornaGradeProd();

      $("#lblCodigo").html($("#txtProduto").val());
      $("#lblDescricao").html($("#txtCor").val());
      $("#tabela-grade").DataTable().rows().remove().draw(false);

      for (let i = 0; i < dataSet.length; i++) {
        const grade = dataSet[i];
        tabelaGrade.row
          .add([
            grade.TAM,
            `<input class="input-default" style="width:150px;" type="number" min="0" max="${0}"/>`,
          ])
          .draw(false);
      }

      $("#modal-grade").modal("show");
    }
  }

  async function RetornaGradeProd() {
    let sCodigo = pegaChave("#txtProduto");
    let sDeposito = pegaChave("#txtDeposito");
    let sCor = pegaChave("#txtCor");
    let sQualidade = pegaChave("#txtQualidade");
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let params = `JSON={"tabela":"pa_iten", "camposSelect":[ "pa_iten.tam", "(SELECT UDF_NVL(SUM(QUANTIDADE)) QTDE FROM [PA_ITEN] PA_ITEN_QTDE WHERE PA_ITEN_QTDE.CODIGO = PA_ITEN.CODIGO AND PA_ITEN_QTDE.COR = PA_ITEN.COR AND PA_ITEN_QTDE.TAM = PA_ITEN.TAM AND PA_ITEN_QTDE.DEPOSITO='${sDeposito}' AND PA_ITEN_QTDE.TIPO='${sQualidade}') as QUANTIDADE"],"leftjoin": [{ "tabela" : "produto", "condicao" : "pa_iten.codigo = produto.codigo" }, { "tabela" : "faixa_iten", "condicao" : "faixa_iten.faixa = produto.faixa and faixa_iten.tamanho = pa_iten.tam" }], "groupby": ["pa_iten.codigo", "pa_iten.cor", "pa_iten.tam",  "faixa_iten.posicao"],"where": ["pa_iten.codigo = '${sCodigo}' and pa_iten.cor='${sCor}' and ([BARRA_VALIDA])"], "orderby": ["faixa_iten.posicao"]}`;

    try {
      let response = await requisicao("GET", url, params, null);

      if (!response) {
        return "";
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return "";
      }

      const arrDados = jsonStr.RESULT[0];
      return arrDados;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados da grade.");
      return "";
    }
  }

  function montaJsonArquivo() {
    const importacao = {
      deposito: $("#txtDeposito").val(),
      qualidade: $("#txtQualidade").val(),
      setor: $("#txtSetor").val(),
      data: $("#txtData").val(),
      itens: montaJsonItens(),
      barrasbipadas: listaBarrasBipadas,
    };
    return importacao;
  }

  $("#btnConfirmar").on("click", async function () {
    try {
      const tabela = $("#tabela-grade").DataTable().data();

      for (let index = 0; index < tabela.length; index++) {
        const quantidade = +$($("td>input")[index]).val();
        const codigo = pegaChave("#txtProduto");
        const cor = pegaChave("#txtCor");
        const tam = tabela[index][0];

        if (quantidade > 0) {
          const response = await buscaDadosBarra(codigo, cor, tam);

          if (!response) {
            SomAlerta(BASE_URI, true);
            return;
          }

          if (response.BARRA != "") {
            $("#txtCodigo").val(response.BARRA);
            $("#txtQuantidade").val(quantidade);
            $("#txtCodigo").trigger("blur");
          } else if (response.BARRA28 != "") {
            $("#txtCodigo").val(response.BARRA28);
            $("#txtQuantidade").val(quantidade);
            $("#txtCodigo").trigger("blur");
          } else if (response.BARRACLI != "") {
            $("#txtCodigo").val(response.BARRACLI);
            $("#txtQuantidade").val(quantidade);
            $("#txtCodigo").trigger("blur");
          }
        }
      }
      $("#txtQuantidade").val(1);
      $("#modal-grade").modal("hide");
    } catch (error) {
      console.error(error);
      SomAlerta(BASE_URI, true);
      msgErro(
        "Não foi localizada nenhuma barra referente ao produto informado."
      );
      return "";
    }


    await VerificaQuantidade();

  });

  $("#modal-grade").on("hidden.bs.modal", function () {
    $("#txtProduto").val("");
    $("#txtCor").val("");
  });

  async function buscaDadosBarra(codigo, cor, tamanho) {
    try {
      const pesquisaParam = {
        tabela: "PA_ITEN",
        camposSelect: ["PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI"],
        where: [
          `PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.COR = '${cor}' AND PA_ITEN.TAM = '${tamanho}'`,
        ],
      };

      const jsonStr = await retornaJsonPesquisaPadrao(
        JSON.stringify(pesquisaParam)
      );

      return jsonStr[0];
    } catch (error) {
      console.error(error);
      msgErro("Erro ao buscar dados.");
      SomAlerta(BASE_URI, true);
      return "";
    }
  }

  async function VerificaQuantidade() {
    const data = $("#tabelaGerarInventarioLoja").DataTable().rows().data();
    let quantidade;
    quantidade = data.reduce((total, date) => total + date[1], quantidade ?? 0);
    $('#txtQuantidadeBipada').val(+quantidade);
  }

  async function VerificaQuantidadeEPC(quantidadeEpc) {
    let qtde = $('#txtQuantidadeBipada').val();
    $('#txtQuantidadeBipada').val(+(qtde + quantidadeEpc));
  }



  $('#btnImportar').click(() => {
    if ($('#txtDeposito').val() == '') {
      msgErro("Preencha o campo depósito.")
      return
    }
    if ($('#txtSetor').val() == '') {
      msgErro("Preencha o campo setor.")
      return
    }
    $('#modalImportarInventario').modal("show");
  })

  $(async function () {
    let modalUploadAnexos = $("#mdModalUpload");
    let Anexo = $('#txtArquivo');
    let BotaoAnexo = $("#btnAddArquivo");
    BotaoAnexo.click(function () {
      modalUploadAnexos.click();
    });

    modalUploadAnexos.change(async function () {
      let NomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
      Anexo.val(NomeAnexo);
    });
  });

  let arrayCSV = [];

  $('input[type="file"]').on('change', function () {
    let input = this;
    let reader = new FileReader();

    const fileName = input.files[0].name;  // Verifica se é CSV
    if (!fileName.endsWith('.csv')) {
      msgErro("Adicione um arquivo com extensão CSV");  // Se não for CSV retorna a mensagem e limpa o campo
      $(this).val("");
      return;
    }

    reader.onload = function () {
      let linhas = reader.result.split('\n').map(function (line) {
        return line;
      });
      arrayCSV = linhas;
    };
    reader.readAsText(input.files[0]);
  });

  $('#btnIncluirAnexo').on('click', function () {
    $.LoadingOverlay("show");
    $('#fechaModal').click();
    async function processLine(index) {
      if (index < arrayCSV.length) {
        let linha = arrayCSV[index].split(";");
        let resultado = linha[0];

        if (resultado.length >= 2) {

          $('#txtQuantidade').val(linha[1].trim());
          $('#txtCodigo').val(linha[0]);
          iniciaIventarioImportacao();
          $('#txtCodigo').val('');
        }

        setTimeout(function () {
          processLine(index + 1);
        }, 500);
      } else {
        $.LoadingOverlay("hide");
        erroMensagem();
        await VerificaQuantidade();
      }
    }
    $('#txtArquivo').val("");
    processLine(0);
  });

  function erroMensagem() {
    if (errosInventario.length > 0) {
      const mensagensDeErro = errosInventario.map(mensagem => {
        const partes = mensagem.split(':');
        if (partes.length > 1) {
          return partes[1].trim();
        }
        return mensagem;
      });
      const mensagemErro = mensagensDeErro.join('\n');
      msgErro(`Ocorreu um erro com os códigos abaixo:\n${mensagemErro}`);

      errosInventario = [];
    } else {
      msgErro("Importação concluída.");
    }
  }

  $('#btnImportarRfid').on('click', async function () {
    await buscaEPCApiSisplan();
  });

  async function buscaEPCApiSisplan() {
    $('#modalRfid').modal('hide');
    $.LoadingOverlay('show');
    try {
      const numero = pegaValor('#txtNumLeitura');
      const deposito = pegaChave('#txtDeposito');
      const qualidade = pegaChave('#txtQualidade');
      let tipoBarra = '0';
      switch ($("input[name=radioBarras]:checked").val()) {
        case "0":
          tipoBarra = "0";
          break;
        case "1":
          tipoBarra = "1";
          break;
        case "2":
          tipoBarra = "2";
          break;
        case "3":
          tipoBarra = "3";
          break;
        case "4":
          tipoBarra = "4";
          break;
        default:
          break;
      }

      if (numero == '') {
        msgAlerta('Necessário informar um número de leitura.');
        return;
      }

      let response = await requisicao('GET', '/sisplan/epc/v1/buscaepcinventario?', `NUMERO=${numero}&DEPOSITO=${deposito}&QUALIDADE=${qualidade}&TIPO_BARRA=${tipoBarra}`, null, 180000);

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      };

      const json = jsonStr.map(objeto => renomearChavesParaMinusculo(objeto));

      let jsonTratado = [];

      let quantidade = 0;

      json.map(async (arraySolo) => {
        const indexValidation = jsonTratado.findIndex((index) => index[8] == arraySolo.barra);

        quantidade = quantidade + arraySolo.quantidade;

        if (indexValidation == -1) {
          jsonTratado.push([
            arraySolo.codigo,
            arraySolo.quantidade,
            arraySolo.descricao,
            arraySolo.deposito,
            arraySolo.lote,
            arraySolo.cor,
            arraySolo.descricaoCor,
            arraySolo.tamanho,
            arraySolo.barra,
            arraySolo.qualidade,
            arraySolo.codigo2,
            "",
            arraySolo.unidade,
            arraySolo.preco,
            arraySolo.posse,
          ]);
        } else {
          jsonTratado[indexValidation][1] = jsonTratado[indexValidation][1] + arraySolo.quantidade;
        }
      });

      $("#tabelaGerarInventarioLoja")
        .DataTable()
        .rows.add(jsonTratado)
        .draw(false);

      $('#txtQuantidadeBipada').val(quantidade);
    } catch (error) {
      console.log(error)
    } finally {
      $('#txtCodigo').val('');
      $.LoadingOverlay('hide');
    }
  };

  function renomearChavesParaMinusculo(objeto) {
    const novoObjeto = {};
    for (let chave in objeto) {
      if (objeto.hasOwnProperty(chave)) {
        novoObjeto[chave == 'DESCRICAOCOR' ? 'descricaoCor' : chave.toLowerCase()] = objeto[chave];
      }
    }
    return novoObjeto;
  }

  // async function buscaEPCApiSisplan() {//rotina antiga
  //   $('#modalRfid').modal('hide');
  //   $.LoadingOverlay('show');
  //   try {
  //     const numero = pegaValor('#txtNumLeitura');
  //     const deposito = pegaChave('#txtDeposito');

  //     if (numero == '') {
  //       msgAlerta('Necessário informar um número de leitura.');
  //       return;
  //     }

  //     let response = await requisicao('GET', '/sisplan/epc/v1/buscaepcexpedicaoapisisplan?', `NUMERO=${numero}&DEPOSITO=${deposito}&INVENTARIO=S`, null, 30000);

  //     const jsonStr = await response.json();

  //     if (response.status != 200) {
  //       msgErro(jsonStr.mensagem);
  //       return;
  //     };

  //     let barra;
  //     for (const epc of jsonStr) {
  //       if (epc.BARRA != '') {
  //         barra = epc.BARRA;
  //       } else if (epc.BARRA28 != '') {
  //         barra = epc.BARRA28;
  //       } else if (epc.BARRACLI != '') {
  //         barra = epc.BARRACLI;
  //       }
  //       $('#txtQuantidade').val(1);
  //       $('#txtCodigo').val(barra);
  //       $('#txtCodigoEPC').val(epc.EPC);
  //       await iniciaInventario();
  //       // await sleep(150);
  //     }

  //   } catch (error) {
  //     console.log(error)
  //   } finally {
  //     $('#txtCodigo').val('');
  //     $.LoadingOverlay('hide');
  //   }
  // };

});
