$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoFluxo",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir um novo fluxo.",
          position: "right",
        },
      },
      {
        element: "#tabelaFluxo",
        popover: {
          title: "Tabela Fluxo",
          description: "Aqui estão os dados dos fluxos cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show')
  })

  $('#btnIncluir').on('click', function () {
    window.location.href = 'formacao_custos/create'
  })

  componenteFiltro('produto', true, true)

  $('#btnConsultar').on('click', async function () {
    await retornarDados()
  })

  async function retornarDados() {
    try {
      $.LoadingOverlay('show')
      const filtros = {
        produtos: await formataListas($('#txtProduto').val().toString())
      }
      const response = await requisicao("GET", `/Sisplan/formacaocustos/v1/retornardadosacesso?`, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 3600000)

      const data = await response.json()

      if (data) {
        const { resultado, mensagem } = data
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (resultado) {
          const { itens } = resultado
          criarTabelaItens(itens || [])
          return
        }
      }
    } catch (error) {
      msgErro(error || 'Ocorreu um erro ao buscar os dados.')
    } finally {
      $('#modal-filtros').modal('hide')
      $.LoadingOverlay('hide')
    }
  }

  function criarTabelaItens(data) {

    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy();
      $('#tabelaItens').empty();
    }

    const columns = [
      {
        data: 'id',
        title: 'Id',
        render: function (data) {
          return retornarBotaoOpcoes(data);
        },
      },
      {
        data: 'codigo',
        title: 'Código',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
    ]

    $("#tabelaItens").DataTable({
      sort: true,
      paging: true,
      destroy: true,
      lengthChange: false,
      filter: false,
      autoWidth: true,
      data,
      columns,
    }).draw(false);
  }

  function retornarBotaoOpcoes(data) {
    const retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      // '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>  ' +
      '</div>'
    return retorno
  }

  $('#tabelaItens').on('click', '#btnEditar', async function () {
    // if (permissaoUsuarioLogado.ALTERA == 'S') {
    let data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data();
    window.location.href = `formacao_custos/${data?.id}`
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!");
    // }
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    // if (permissaoUsuarioLogado.ALTERA == 'S') {
    const data = $('#tabelaItens').DataTable().row($(this)).data();
    if (!data) {
      return
    }
    window.location.href = `formacao_custos/${data.id}`;
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!");
    // }
  });
})