<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Ocorrência</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.257.10.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.257.10.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">


  <link rel="stylesheet" href="dist/css/custom.css?versao=3.257.10.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.257.10.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.257.10.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.257.10.1" />
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.257.10.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.257.10.1">

  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.257.10.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.257.10.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.257.10.1">
  <style>
    .table.dataTable tbody,
    .table.dataTable thead {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    #txtTipo,
    #txtOperacao {
      border-color: darkgray;
    }

    #tabelaDados td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaDados td {
      padding: 0 !important;
      padding-left: 10px !important;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Cadastro de Ocorrência</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div><!-- /.col -->
            <div class="col-sm-6">

            </div><!-- /.col -->
          </div><!-- /.row -->
        </div>
        <div class="container-fluid">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <!-- <div class="btn-group ml-3"> -->
              <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span>
                Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
              <button class="btn btn-success btn-sisp" id="btnImprimir"><i class="fas fa-print"></i> Imprimir</button>
              <!-- </div> -->
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Ocorrências</h5>
              <table id="tabelaDados" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Banco
                    </th>
                    <th class="th-sm">Nome Banco
                    </th>
                    <th class="th-sm">Ocorrência
                    </th>
                    <th class="th-sm">Desc. Ocorrencia
                    </th>
                    <th class="th-sm">Situação
                    </th>
                    <th class="th-sm">Desc. Situação
                    </th>
                    <th class="th-sm">Carteira
                    </th>
                    <th class="th-sm">Histórico
                    </th>
                    <th class="th-sm">Desc. Histórico
                    </th>
                    <th class="th-sm">Classe
                    </th>
                    <th class="th-sm">Desc. Classe
                    </th>
                    <th class="th-sm">Tipo
                    </th>
                    <th class="th-sm">Operação
                    </th>
                    <th class="th-sm">Conta
                    </th>
                    <th class="th-sm">Alterar Banco
                    </th>
                    <th class="th-sm">Banco Alt
                    </th>
                    <th class="th-sm">Id
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
          <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content" id="modalBody">
              <div class="modal-header">
                <h4 class="modal-title">Filtros</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">

                <div class="form-row col-lg-12 col-md-12 col-sm-12">
                  <div class="form-group col-lg-2 col-md-12 col-sm-12">
                    <label for="txtTipo">Tipo</label>
                    <select id="txtTipo" class="input-default focus custom-select select-ent">
                      <option value="E" selected>Entrada</option>
                      <option value="S">Saída</option>
                    </select>
                  </div>
                  <div class="form-group col-lg-2 col-md-12 col-sm-12">
                    <label for="txtOperacao">Operação</label>
                    <select id="txtOperacao" class="input-default focus custom-select select-ent">
                      <option value="C" selected>Cobrança</option>
                      <option value="P">Pagamento</option>
                    </select>
                  </div>
                  <div class="form-group col-lg-2 col-md-12 col-sm-12" id="nomeTour">
                    <label>Ocorrência</label>
                    <input type="text" class="input-default focus form-control validate" id="txtCodigo" name="txtCodigo" required placeholder="Código">
                  </div>
                  <div class="form-group col-lg-6 col-md-12 col-sm-12" id="nomeTour">
                    <label>Descrição</label>
                    <input type="text" class="input-default focus form-control validate" id="txtDescricao" name="txtDescricao" required placeholder="Descrição">
                  </div>
                  <div class="form-group col-lg-4 col-md-12 col-sm-12">
                    <label data-error="wrong" data-success="right" for="txtBanco">Banco: </label>
                    <div class="input-group">
                      <select class="js-example-programmatic js-states form-control" id="txtBanco" name="txtBanco" multiple="multiple">
                      </select>
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnBanco" name="btnBanco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaBanco" name="btnLimpaBanco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-lg-4 col-md-12 col-sm-12">
                    <label data-error="wrong" data-success="right" for="txtSituacao">Situação: </label>
                    <div class="input-group">
                      <select class="js-example-programmatic js-states form-control" id="txtSituacao" name="txtSituacao" multiple="multiple">
                      </select>
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnSituacao" name="btnSituacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaSituacao" name="btnLimpaSituacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-lg-4 col-md-12 col-sm-12">
                    <label data-error="wrong" data-success="right" for="txtCarteira">Carteira: </label>
                    <div class="input-group">
                      <select class="js-example-programmatic js-states form-control" id="txtCarteira" name="txtCarteira" multiple="multiple">
                      </select>
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnCarteira" name="btnCarteira" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaCarteira" name="btnLimpaCarteira" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-lg-4 col-md-12 col-sm-12">
                    <label data-error="wrong" data-success="right" for="txtHistorico">Histórico: </label>
                    <div class="input-group">
                      <select class="js-example-programmatic js-states form-control" id="txtHistorico" name="txtHistorico" multiple="multiple">
                      </select>
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnHistorico" name="btnHistorico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaHistorico" name="btnLimpaHistorico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-lg-4 col-md-12 col-sm-12">
                    <label data-error="wrong" data-success="right" for="txtClasse">Classe: </label>
                    <div class="input-group">
                      <select class="js-example-programmatic js-states form-control" id="txtClasse" name="txtClasse" multiple="multiple">
                      </select>
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnClasse" name="btnClasse" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaClasse" name="btnLimpaClasse" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                </div>

              </div>
              <div class="modal-footer">
                <div class="row">
                  <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar
                    Filtros</button>     
                  <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span>
                    Consultar</button>
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>

    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <?php
  include_once('../../../modais.php');
  include_once('../../../modals/modal_anexos.html');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->
  <script src="plugins/jquery/jquery.min.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.257.10.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.257.10.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.257.10.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.257.10.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.257.10.1"></script>
  <script src="utils/cookies.js?versao=3.257.10.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.257.10.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.257.10.1"></script>
  <script src="dist/js/driver.min.js?versao=3.257.10.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="config.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="plugins/select2/js/select2.full.min.js?versao=3.257.10.1"></script>
  <script src="utils/funcoes.js?versao=3.257.10.1"></script>
  <script src="dist/js/sisplan.js?versao=3.257.10.1"></script>


  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('ESCOCORRENCIA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/escocorrencia/acesso_escocorrencia/acesso_escocorrencia.js?versao=3.257.10.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>