<!DOCTYPE html>
<html>

<style>
  .bordaTabelaItensManutencao {
    padding: 10px;
    border: solid #e0e4e6;
    border-radius: 4px;
    border-width: 1px;
  }

  #tabelaMateriaisManutencao tbody td,
  #tabelaMateriaisManutencao thead {
    white-space: nowrap;
    text-overflow: ellipsis;
    overflow: hidden;
  }

  #tabelaMateriaisManutencao tr td,
  #tabelaMateriaisManutencao th {
    padding: 4px 12px;
  }

  .error {
    color: #dc3545 !important;
  }

  #divMateriais,
  #divProdutos,
  #divServicos {
    padding-right: 1px;
    padding-left: 1px;
  }
</style>

<head>
  <meta charset="utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link
    rel="stylesheet"
    href="../plugins/fontawesome-free/css/all.min.css?versao=3.257.10.1" />

  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.257.10.1" />
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.257.10.1" />
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.257.10.1" />
  <link
    rel="stylesheet"
    type="text/css"
    href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.257.10.1" />
  <link
    rel="stylesheet"
    href="../plugins/toastr/toastr.min.css?versao=3.257.10.1" />
  <link
    rel="stylesheet"
    href="../plugins/fontawesome-free/css/all.min.css?versao=3.257.10.1" />
  <link rel="shortcut icon" href="../favicon.ico" />
  <link
    rel="stylesheet"
    type="text/css"
    href="../dist/css/driver.min.css?versao=3.257.10.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.257.10.1" />
  <link
    rel="stylesheet"
    href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.257.10.1" />
  <link
    href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700"
    rel="stylesheet" />
  <link
    rel="stylesheet"
    type="text/css"
    href="../dist/css/bootstrap-tagsinput.css?versao=3.257.10.1" />
</head>

<body>
  <div
    class="modal fade"
    data-backdrop="static"
    id="modalManutencao"
    tabindex="-1"
    role="dialog"
    aria-labelledby="modalManutencao"
    aria-hidden="true">
    <div class="modal-dialog" style="min-width: 99%; min-height: 100%">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Manutenção de Cotação</h4>
          <button
            type="button"
            class="close"
            data-dismiss="modal"
            aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <nav class="col-12 px-0">
            <div
              class="nav nav-tabs d-flex flex-nowrap"
              id="nav-tab"
              role="tablist"
              style="
                text-decoration: none;
                max-width: none !important;
                white-space: nowrap !important;
                overflow-x: auto !important;
                overflow-y: hidden;
              ">
              <a
                class="nav-link abaLink active"
                id="tabCapa"
                data-toggle="tab"
                href="#divCapa"
                role="tab"
                aria-controls="divCapa"
                aria-selected="true">Capa</a>
              <a
                class="nav-link abaLink"
                id="tabItens"
                data-toggle="tab"
                href="#divItens"
                role="tab"
                aria-controls="divItens"
                aria-selected="false">Itens</a>
            </div>
          </nav>
          <div class="tab-content col-12 px-0" id="nav-tabContent">
            <div
              id="divCapa"
              class="tab-pane fade show active"
              role="tabpanel"
              aria-labelledby="tabCapa">
              <form id="formCapa">
                <div class="form-row">
                  <div class="col-xl-1 col-md-2 col-12 form-group">
                    <label
                      data-error="wrong"
                      class="labelGeral"
                      data-success="right"
                      for="txtNumeroCapa">Número:</label>
                    <input
                      autocomplete="off"
                      class="input-default focus form-control camposCapaManutencao"
                      id="txtNumeroCapa"
                      placeholder="Número"
                      name="numero"
                      readonly />
                  </div>
                  <div class="col-xl-1 col-md-2 col-12 form-group">
                    <label
                      data-error="wrong"
                      class="labelGeral"
                      data-success="right"
                      for="txtUsuarioCapa">Usuário:</label>
                    <input
                      autocomplete="off"
                      class="input-default focus form-control camposCapaManutencao"
                      id="txtUsuarioCapa"
                      placeholder="Usuário"
                      name="usuario"
                      readonly />
                  </div>
                  <div class="col-xl-1 col-md-2 col-12 form-group">
                    <label
                      data-error="wrong"
                      class="labelGeral"
                      data-success="right"
                      for="txtEmissaoCapa">Emissão:</label>
                    <input
                      autocomplete="off"
                      type="date"
                      class="input-default focus form-control camposCapaManutencao controleCapaManutencao"
                      id="txtEmissaoCapa"
                      placeholder="Especificação"
                      name="dataEmissao"
                      disabled />
                  </div>
                  <div class="col-xl-1 col-md-2 col-12 form-group">
                    <label
                      data-error="wrong"
                      class="labelGeral"
                      data-success="right"
                      for="txtEntregaCapa">Entrega:</label>
                    <input
                      autocomplete="off"
                      type="date"
                      class="input-default focus form-control camposCapaManutencao controleCapaManutencao"
                      id="txtEntregaCapa"
                      placeholder="Especificação"
                      name="dataEntrega"
                      disabled />
                  </div>
                  <div class="col-xl-4 col-lg-4 col-md-6 col-12 form-group">
                    <label
                      data-error="wrong"
                      class="labelGeral"
                      data-success="right"
                      for="txtFornecedorCapa">Fornecedor:</label>
                    <div class="input-group">
                      <input
                        autocomplete="off"
                        type="text"
                        class="input-default focus form-control camposCapaManutencao controleCapaManutencao"
                        id="txtFornecedorCapa"
                        name="fornecedor"
                        placeholder="Fornecedor"
                        disabled />
                      <div class="input-group-append">
                        <button
                          class="btn bg-danger controleCapaManutencao"
                          id="btnFornecedorCapa"
                          name="btnFornecedorCapa"
                          data-button="absolute"
                          type="button"
                          disabled>
                          <i class="m-0 p-0 fas fa-search"></i>
                        </button>
                        <button
                          class="btn bg-danger controleCapaManutencao"
                          id="btnLimpaFornecedorCapa"
                          name="btnLimpaFornecedorCapa"
                          type="button"
                          disabled>
                          <i class="m-0 p-0 fas fa-trash"></i>
                        </button>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-4 col-lg-4 col-md-6 col-12 form-group">
                    <label
                      data-error="wrong"
                      class="labelGeral"
                      data-success="right"
                      for="txtPrazoCapa">Prazo:</label>
                    <div class="input-group">
                      <input
                        autocomplete="off"
                        type="text"
                        class="input-default focus form-control camposCapaManutencao controleCapaManutencao"
                        id="txtPrazoCapa"
                        name="prazo"
                        placeholder="Prazo"
                        disabled />
                      <div class="input-group-append">
                        <button
                          class="btn bg-danger controleCapaManutencao"
                          id="btnPrazoCapa"
                          name="btnPrazoCapa"
                          data-button="absolute"
                          type="button"
                          disabled>
                          <i class="m-0 p-0 fas fa-search"></i>
                        </button>
                        <button
                          class="btn bg-danger controleCapaManutencao"
                          id="btnLimpaPrazoCapa"
                          name="btnLimpaPrazoCapa"
                          type="button"
                          disabled>
                          <i class="m-0 p-0 fas fa-trash"></i>
                        </button>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                    <label
                      data-error="wrong"
                      class="labelGeral"
                      data-success="right"
                      for="txtColecaoCapa">Coleção:</label>
                    <div class="input-group">
                      <input
                        autocomplete="off"
                        type="text"
                        class="input-default focus form-control camposCapaManutencao controleCapaManutencao"
                        id="txtColecaoCapa"
                        name="colecao"
                        placeholder="Coleção"
                        disabled />
                      <div class="input-group-append">
                        <button
                          class="btn bg-danger controleCapaManutencao"
                          id="btnColecaoCapa"
                          name="btnColecaoCapa"
                          data-button="absolute"
                          type="button"
                          disabled>
                          <i class="m-0 p-0 fas fa-search"></i>
                        </button>
                        <button
                          class="btn bg-danger controleCapaManutencao"
                          id="btnLimpaColecaoCapa"
                          name="btnLimpaColecaoCapa"
                          type="button"
                          disabled>
                          <i class="m-0 p-0 fas fa-trash"></i>
                        </button>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                    <label
                      data-error="wrong"
                      class="labelGeral"
                      data-success="right"
                      for="txtMotivoCapa">Motivo:</label>
                    <div class="input-group">
                      <input
                        autocomplete="off"
                        type="text"
                        class="input-default focus form-control camposCapaManutencao controleCapaManutencao"
                        id="txtMotivoCapa"
                        name="motivo"
                        placeholder="Motivo"
                        disabled />
                      <div class="input-group-append">
                        <button
                          class="btn bg-danger controleCapaManutencao"
                          id="btnMotivoCapa"
                          name="btnMotivoCapa"
                          data-button="absolute"
                          type="button"
                          disabled>
                          <i class="m-0 p-0 fas fa-search"></i>
                        </button>
                        <button
                          class="btn bg-danger controleCapaManutencao"
                          id="btnLimpaMotivoCapa"
                          name="btnLimpaMotivoCapa"
                          type="button"
                          disabled>
                          <i class="m-0 p-0 fas fa-trash"></i>
                        </button>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-lg-4 col-md-6 col-12 form-group">
                    <label
                      data-error="wrong"
                      class="labelGeral"
                      data-success="right"
                      for="txtObservacaoCapa">Observação:</label>
                    <input
                      autocomplete="off"
                      class="input-default focus form-control camposCapaManutencao controleCapaManutencao"
                      id="txtObservacaoCapa"
                      placeholder="Observação"
                      name="observacao"
                      disabled />
                  </div>
                  <select id="selectStatus" class="d-none">
                    <option value="D">Digitado</option>
                    <option value="B">Bloqueado</option>
                    <option value="R">Retornado</option>
                    <option value="L">Liberado</option>
                    <option value="E">Enviado</option>
                    <option value="A">Aceito</option>
                    <option value="N">Rejeitado</option>
                  </select>
                  <div class="col-xl-3 col-lg-4 col-12 form-group">
                    <div class="flex align-items-end h-100" style="gap: 8px">
                      <button type="submit" class="btn btn-primary btn-sisp d-none" id="btnConfirmarCapa" style="max-height: 38px">Confirmar</button>
                      <button type="button" class="btn btn-danger btn-sisp d-none" id="btnDesistirCapa" style="max-height: 38px">Desistir</button>
                      <button type="button" class="btn btn-primary btn-sisp" id="btnAlterarCapa" style="max-height: 38px">Alterar</button>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <div
              id="divItens"
              class="tab-pane fade"
              role="tabpanel"
              aria-labelledby="tabItens">
              <nav class="col-12 px-0 mt-1">
                <div
                  class="nav nav-tabs d-flex flex-nowrap"
                  id="nav-tab"
                  role="tablist"
                  style="
                  text-decoration: none;
                  max-width: none !important;
                  white-space: nowrap !important;
                  overflow-x: auto !important;
                  overflow-y: hidden;
                ">
                  <a
                    class="nav-link abaLink active"
                    id="tabMateriais"
                    data-toggle="tab"
                    href="#divMateriais"
                    role="tab"
                    aria-controls="divMateriais"
                    aria-selected="true">Materiais</a>
                  <a
                    class="nav-link abaLink"
                    id="tabProdutos"
                    data-toggle="tab"
                    href="#divProdutos"
                    role="tab"
                    aria-controls="divProdutos"
                    aria-selected="false">Produtos</a>
                  <a
                    class="nav-link abaLink"
                    id="tabServicos"
                    data-toggle="tab"
                    href="#divServicos"
                    role="tab"
                    aria-controls="divServicos"
                    aria-selected="false">Serviços</a>
                </div>
              </nav>
              <div class="tab-content col-12 px-0" id="nav-tabContent">
                <div
                  id="divMateriais"
                  class="tab-pane fade show active"
                  role="tabpanel"
                  aria-labelledby="tabMateriais">
                  <form id="formMaterial">
                    <div class="form-row">
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtCodigoMaterial">Material:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposMaterialManutencao controleMaterialManutencao"
                            id="txtCodigoMaterial"
                            name="codigo"
                            placeholder="Material"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleMaterialManutencao"
                              id="btnCodigoMaterial"
                              name="btnCodigoMaterial"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleMaterialManutencao"
                              id="btnLimpaCodigoMaterial"
                              name="btnLimpaCodigoMaterial"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtCorMaterial">Cor:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposMaterialManutencao controleMaterialManutencao"
                            id="txtCorMaterial"
                            name="cor"
                            placeholder="Cor"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleMaterialManutencao"
                              id="btnCorMaterial"
                              name="btnCorMaterial"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleMaterialManutencao"
                              id="btnLimpaCorMaterial"
                              name="btnLimpaCorMaterial"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtDepositoMaterial">Depósito:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposMaterialManutencao controleMaterialManutencao"
                            id="txtDepositoMaterial"
                            name="deposito"
                            placeholder="Depósito"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleMaterialManutencao"
                              id="btnDepositoMaterial"
                              name="btnDepositoMaterial"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleMaterialManutencao"
                              id="btnLimpaDepositoMaterial"
                              name="btnLimpaDepositoMaterial"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtCentroCustoMaterial">Centro de Custo:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposMaterialManutencao controleMaterialManutencao"
                            id="txtCentroCustoMaterial"
                            name="centroCusto"
                            placeholder="Centro de Custo"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleMaterialManutencao"
                              id="btnCentroCustoMaterial"
                              name="btnCentroCustoMaterial"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleMaterialManutencao"
                              id="btnLimpaCentroCustoMaterial"
                              name="btnLimpaCentroCustoMaterial"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtContaContabilMaterial">Conta Contábil:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposMaterialManutencao controleMaterialManutencao"
                            id="txtContaContabilMaterial"
                            name="contaContabil"
                            placeholder="Conta Contábil"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleMaterialManutencao"
                              id="btnContaContabilMaterial"
                              name="btnContaContabilMaterial"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleMaterialManutencao"
                              id="btnLimpaContaContabilMaterial"
                              name="btnLimpaContaContabilMaterial"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtEspecificacaoMaterial">Especificação:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control camposMaterialManutencao controleMaterialManutencao"
                          id="txtEspecificacaoMaterial"
                          placeholder="Especificação"
                          name="especificacao"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtUnidadeMaterial">Unidade:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control camposMaterialManutencao controleMaterialManutencao"
                          id="txtUnidadeMaterial"
                          placeholder="UN"
                          name="unidade"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtUnidadeCompraMaterial">Unidade Compra:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control camposMaterialManutencao controleMaterialManutencao"
                          id="txtUnidadeCompraMaterial"
                          placeholder="UN"
                          name="unidadeCompra"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtFatorConversaoMaterial">Fator Conversão:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control text-right camposMaterialManutencao controleMaterialManutencao campoFloat"
                          id="txtFatorConversaoMaterial"
                          placeholder="0.00"
                          name="fatorConversao"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtQuantidadeMaterial">Quantidade:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control text-right camposMaterialManutencao controleMaterialManutencao campoFloat"
                          id="txtQuantidadeMaterial"
                          placeholder="0.00"
                          name="quantidade"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtPrecoMaterial">Preço:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control text-right camposMaterialManutencao controleMaterialManutencao campoFloat"
                          id="txtPrecoMaterial"
                          placeholder="0.00"
                          name="preco"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtValorMaterial">Valor:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control text-right camposMaterialManutencao"
                          id="txtValorMaterial"
                          placeholder="0.00"
                          name="valor"
                          disabled />
                      </div>
                      <div class="col-xl-3 col-lg-4 col-12 form-group">
                        <div class="flex align-items-end h-100" style="gap: 8px">
                          <button type="button" class="btn btn-primary btn-sisp" id="btnIncluirMaterial" style="max-height: 38px">Incluir</button>
                          <button type="submit" class="btn btn-primary btn-sisp d-none" id="btnConfirmarMaterial" style="max-height: 38px">Confirmar</button>
                          <button type="button" class="btn btn-danger btn-sisp d-none" id="btnDesistirMaterial" style="max-height: 38px">Desistir</button>
                          <button type="button" class="btn btn-primary btn-sisp" id="btnAlterarMaterial" style="max-height: 38px">Alterar</button>
                          <button type="button" class="btn btn-danger btn-sisp" id="btnExcluirMaterial" style="max-height: 38px">Excluir</button>
                        </div>
                      </div>
                    </div>
                  </form>
                  <div class="form-row px-1">
                    <div class="flex flex-column col-12 px-0 bordaTabelaItensManutencao mb-2">
                      <div class="table-responsive col-12">
                        <table id="tabelaMateriaisManutencao" class="table table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
                <div
                  id="divProdutos"
                  class="tab-pane fade"
                  role="tabpanel"
                  aria-labelledby="tabProdutos">
                  <form id="formProduto">
                    <div class="form-row">
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtCodigoProduto">Produto:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposProdutoManutencao controleProdutoManutencao"
                            id="txtCodigoProduto"
                            name="codigo"
                            placeholder="Produto"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnCodigoProduto"
                              name="btnCodigoProduto"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnLimpaCodigoProduto"
                              name="btnLimpaCodigoProduto"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtCorProduto">Cor:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposProdutoManutencao controleProdutoManutencao"
                            id="txtCorProduto"
                            name="cor"
                            placeholder="Cor"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnCorProduto"
                              name="btnCorProduto"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnLimpaCorProduto"
                              name="btnLimpaCorProduto"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtTamanhoProduto">Tamanho:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposProdutoManutencao controleProdutoManutencao"
                            id="txtTamanhoProduto"
                            name="tamanho"
                            placeholder="Tamanho"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnTamanhoProduto"
                              name="btnTamanhoProduto"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnLimpaTamanhoProduto"
                              name="btnLimpaTamanhoProduto"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtDepositoProduto">Depósito:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposProdutoManutencao controleProdutoManutencao"
                            id="txtDepositoProduto"
                            name="deposito"
                            placeholder="Depósito"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnDepositoProduto"
                              name="btnDepositoProduto"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnLimpaDepositoProduto"
                              name="btnLimpaDepositoProduto"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtCentroCustoProduto">Centro de Custo:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposProdutoManutencao controleProdutoManutencao"
                            id="txtCentroCustoProduto"
                            name="centroCusto"
                            placeholder="Centro de Custo"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnCentroCustoProduto"
                              name="btnCentroCustoProduto"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnLimpaCentroCustoProduto"
                              name="btnLimpaCentroCustoProduto"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtContaContabilProduto">Conta Contábil:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposProdutoManutencao controleProdutoManutencao"
                            id="txtContaContabilProduto"
                            name="contaContabil"
                            placeholder="Conta Contábil"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnContaContabilProduto"
                              name="btnContaContabilProduto"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleProdutoManutencao"
                              id="btnLimpaContaContabilProduto"
                              name="btnLimpaContaContabilProduto"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtEspecificacaoProduto">Especificação:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control camposProdutoManutencao controleProdutoManutencao"
                          id="txtEspecificacaoProduto"
                          placeholder="Especificação"
                          name="especificacao"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtUnidadeProduto">Unidade:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control camposProdutoManutencao controleProdutoManutencao"
                          id="txtUnidadeProduto"
                          placeholder="UN"
                          name="unidade"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtUnidadeCompraProduto">Unidade Compra:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control camposProdutoManutencao controleProdutoManutencao"
                          id="txtUnidadeCompraProduto"
                          placeholder="UN"
                          name="unidadeCompra"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtQuantidadeProduto">Quantidade:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control text-right camposProdutoManutencao controleProdutoManutencao campoFloat"
                          id="txtQuantidadeProduto"
                          placeholder="0.00"
                          name="quantidade"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtPrecoProduto">Preço:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control text-right camposProdutoManutencao controleProdutoManutencao campoFloat"
                          id="txtPrecoProduto"
                          placeholder="0.00"
                          name="preco"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtValorProduto">Valor:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control text-right camposProdutoManutencao"
                          id="txtValorProduto"
                          placeholder="0.00"
                          name="valor"
                          disabled />
                      </div>
                      <div class="col-xl-3 col-lg-4 col-12 form-group">
                        <div class="flex align-items-end h-100" style="gap: 8px">
                          <button type="button" class="btn btn-primary btn-sisp" id="btnIncluirProduto" style="max-height: 38px">Incluir</button>
                          <button type="submit" class="btn btn-primary btn-sisp d-none" id="btnConfirmarProduto" style="max-height: 38px">Confirmar</button>
                          <button type="button" class="btn btn-danger btn-sisp d-none" id="btnDesistirProduto" style="max-height: 38px">Desistir</button>
                          <button type="button" class="btn btn-primary btn-sisp" id="btnAlterarProduto" style="max-height: 38px">Alterar</button>
                          <button type="button" class="btn btn-danger btn-sisp" id="btnExcluirProduto" style="max-height: 38px">Excluir</button>
                        </div>
                      </div>
                    </div>
                  </form>
                  <div class="form-row px-1">
                    <div class="flex flex-column col-12 px-0 bordaTabelaItensManutencao mb-2">
                      <div class="table-responsive col-12">
                        <table id="tabelaProdutosManutencao" class="table table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
                <div
                  id="divServicos"
                  class="tab-pane fade"
                  role="tabpanel"
                  aria-labelledby="tabServicos">
                  <form id="formServico">
                    <div class="form-row">
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtCodigoServico">Serviço:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposServicoManutencao controleServicoManutencao"
                            id="txtCodigoServico"
                            name="codigo"
                            placeholder="Servico"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleServicoManutencao"
                              id="btnCodigoServico"
                              name="btnCodigoServico"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleServicoManutencao"
                              id="btnLimpaCodigoServico"
                              name="btnLimpaCodigoServico"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtCentroCustoServico">Centro de Custo:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposServicoManutencao controleServicoManutencao"
                            id="txtCentroCustoServico"
                            name="centroCusto"
                            placeholder="Centro de Custo"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleServicoManutencao"
                              id="btnCentroCustoServico"
                              name="btnCentroCustoServico"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleServicoManutencao"
                              id="btnLimpaCentroCustoServico"
                              name="btnLimpaCentroCustoServico"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtContaContabilServico">Conta Contábil:</label>
                        <div class="input-group">
                          <input
                            autocomplete="off"
                            type="text"
                            class="input-default focus form-control camposServicoManutencao controleServicoManutencao"
                            id="txtContaContabilServico"
                            name="contaContabil"
                            placeholder="Conta Contábil"
                            disabled />
                          <div class="input-group-append">
                            <button
                              class="btn bg-danger controleServicoManutencao"
                              id="btnContaContabilServico"
                              name="btnContaContabilServico"
                              data-button="absolute"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-search"></i>
                            </button>
                            <button
                              class="btn bg-danger controleServicoManutencao"
                              id="btnLimpaContaContabilServico"
                              name="btnLimpaContaContabilServico"
                              type="button"
                              disabled>
                              <i class="m-0 p-0 fas fa-trash"></i>
                            </button>
                          </div>
                        </div>
                      </div>
                      <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtEspecificacaoServico">Especificação:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control camposServicoManutencao controleServicoManutencao"
                          id="txtEspecificacaoServico"
                          placeholder="Especificação"
                          name="especificacao"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtQuantidadeServico">Quantidade:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control text-right camposServicoManutencao controleServicoManutencao campoFloat"
                          id="txtQuantidadeServico"
                          placeholder="0.00"
                          name="quantidade"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtPrecoServico">Preço:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control text-right camposServicoManutencao controleServicoManutencao campoFloat"
                          id="txtPrecoServico"
                          placeholder="0.00"
                          name="preco"
                          disabled />
                      </div>
                      <div class="col-xl-1 col-lg-4 col-md-6 col-12 form-group">
                        <label
                          data-error="wrong"
                          class="labelGeral"
                          data-success="right"
                          for="txtValorServico">Valor:</label>
                        <input
                          autocomplete="off"
                          class="input-default focus form-control text-right camposServicoManutencao"
                          id="txtValorServico"
                          placeholder="0.00"
                          name="valor"
                          disabled />
                      </div>
                      <div class="col-xl-3 col-lg-4 col-12 form-group">
                        <div class="flex align-items-end h-100" style="gap: 8px">
                          <button type="button" class="btn btn-primary btn-sisp" id="btnIncluirServico" style="max-height: 38px">Incluir</button>
                          <button type="submit" class="btn btn-primary btn-sisp d-none" id="btnConfirmarServico" style="max-height: 38px">Confirmar</button>
                          <button type="button" class="btn btn-danger btn-sisp d-none" id="btnDesistirServico" style="max-height: 38px">Desistir</button>
                          <button type="button" class="btn btn-primary btn-sisp" id="btnAlterarServico" style="max-height: 38px">Alterar</button>
                          <button type="button" class="btn btn-danger btn-sisp" id="btnExcluirServico" style="max-height: 38px">Excluir</button>
                        </div>
                      </div>
                    </div>
                  </form>
                  <div class="form-row px-1">
                    <div class="flex flex-column col-12 px-0 bordaTabelaItensManutencao mb-2">
                      <div class="table-responsive col-12">
                        <table id="tabelaServicosManutencao" class="table table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button
            type="button"
            class="btn btn-primary btn-sisp"
            id="btnConfirmar">
            Confirmar
          </button>
          <button
            class="btn btn-danger btn-sisp"
            class="close"
            data-dismiss="modal"
            aria-label="Close"
            id="btnCancelar">
            Cancelar
          </button>
        </div>
      </div>
    </div>
  </div>
</body>
<?php
include_once('../../modais.php')
?>

</html>