$("#tutorial").on("click", function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
        });
        driver.defineSteps([
            {
                element: "#btnFiltros",
                popover: {
                    title: "Botão Filtros",
                    description: "Clique aqui para filtrar a consulta.",
                    position: "right",
                },
            },
            {
                element: "#btnNovaOrdemProducao",
                popover: {
                    title: "Botão Incluir",
                    description: "Clique aqui para incluir uma nova ordem de produção.",
                    position: "right",
                },
            },
            {
                element: "#tabelaOs",
                popover: {
                    title: "Tabela Ordem de Produção Simples",
                    description: "Aqui estão os dados das ordens de produção cadastradas.",
                    position: "top",
                },
            },
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    let tipoCodigo = 'P';

    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let sequencia = parametros[parametros.length - 1];
    let arrayComissoes = [];
    const permissaoUsuarioLogado = await permissaoAcessos("CADCOMISSAO");

    $("#txtProduto").autocompleta(3, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["1 = 1"] }`);
    $("#btnProduto").pesquisa_serverside(["#txtProduto"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["1 = 1"]}`, "Pesquisa Produto");
    $("#btnLimpaProduto").on("click", function () { $("#txtProduto").val(""); });

    $("#txtTabPreco").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btnTabPreco").pesquisa_serverside(["#txtTabPreco"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}`, "Pesquisa Tabela de Preço");
    $("#btnLimpaTabPreco").on("click", function () { $("#txtTabPreco").val(""); });

    $("#txtMaterial").autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btnMaterial").pesquisa_serverside(["#txtMaterial"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Material");
    $("#btnLimpaMaterial").on("click", function () { $("#txtMaterial").val(""); });

    $("#txtRepresentante").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btnRepresentante").pesquisa_serverside(["#txtRepresentante"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Representante");
    $("#btnLimpaRepresentante").on("click", function () { $("#txtRepresentante").val(""); });

    if (sequencia == 'create') {
        const ordem = await RetornaProximo('GRUPO_COMISSAO', 'GRUPO_COMISSAO', 'SEQ', 5);
        $('#txtOrdem').val(ordem);
    } else {
        $('#txtOrdem').val(sequencia);
        $('#txtOrdem').prop('disabled', true);
    };


    $('#txtOrdem').on('blur', async function () {
        const valor = $('#txtOrdem').val();

        if (valor == '') {
            $('#txtOrdem').val(`${await RetornaProximo('GRUPO_COMISSAO', 'GRUPO_COMISSAO', 'SEQ', 5)}`)
        }
    });

    $('#rdProduto').on('click', function () {
        $('#ProdutoInfoTour').removeClass('d-none');
        $('#MaterialInfoTour').addClass('d-none');
        $('#txtMaterial').val('');
        tipoCodigo = 'P'
    });

    $('#rdMaterial').on('click', function () {
        $('#ProdutoInfoTour').addClass('d-none');
        $('#MaterialInfoTour').removeClass('d-none');
        $('#txtProduto').val('');
        tipoCodigo = 'M'
    });

    $('#btnExcluir').on('click', async function () {
        const dadosComissoes = $('#tabelaComissoesCadastro').DataTable().data().toArray();

        if (dadosComissoes.length <= 0) {
            msgAlerta('Sem registros para excluir! Por favor, verifique.');
            return
        };

        msgAguardaConfirmacao('Tem certeza que deseja excluir todas as comissões dessa sequência?', async () => {
            $('#tabelaComissoesCadastro').DataTable().clear().draw();
            arrayComissoes = [];
            await deletaSequenciaComissoes(sequencia);
        }, () => { })
    });

    $('#btnVoltar').on('click', async function () {
        window.location.href = `${BASE_URI}/comissao`;
    });

    $('#btnGravar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const dadosComissoes = $('#tabelaComissoesCadastro').DataTable().data().toArray();

            if (sequencia != 'create') {
                if (dadosComissoes.length <= 0) {
                    msgAguardaConfirmacao('Se gravar a sequência vazia sem comissões, ela vai ser excluída, tem certeza que deseja fazer isso?',
                        async () => {
                            if (permissaoUsuarioLogado.EXCLUI == 'S') {
                                await deletaSequenciaComissoes($('#txtOrdem').val());
                            } else {
                                msgAlerta('Você não tem permissão pra excluir essa sequência de comissões')
                            };
                        },
                        () => { });
                    return;
                }
            } else {
                if (dadosComissoes.length <= 0) {
                    msgAlerta('Não existe registros para gravar. Por favor, verifique!');
                    return
                }
            }

            let registros = [];

            for (x in dadosComissoes) {
                let registroComissao = {
                    SEQUENCIA: dadosComissoes[x].SEQUENCIA,
                    CODIGO: dadosComissoes[x].CODIGO,
                    DESCDE: String(dadosComissoes[x].DESC_DE),
                    DESCATE: String(dadosComissoes[x].DESC_ATE),
                    COMISSAO: String(dadosComissoes[x].COMISSAO),
                    TIPO: dadosComissoes[x].TIPO,
                    CODREP: dadosComissoes[x].REPRESENTANTE,
                    TABPRECO: dadosComissoes[x].TAB_PRE,
                    DESCONTO: '0'
                }

                registros.push(registroComissao);
            };

            const response = await requisicao('POST', '/sisplan/cadcomissao/v1/cadastracomissoes?', '', `LISTACOMISSOES=${encodeURIComponent(JSON.stringify({ COMISSOES: registros }))}`, 90000);

            if (!response) {
                $.LoadingOverlay('hide');
                return;
            }

            if (response.status != 200) {
                const jsonStr = await response.json();
                $.LoadingOverlay('hide');
                msgErro(jsonStr.mensagem);
                return;
            }

            $.LoadingOverlay('hide');

            criaMensagemSucesso(`Sequência ${registros[0].SEQUENCIA} de comissões gravada com sucesso.`, () => { window.location.href = `${BASE_URI}/comissao`; });
        } catch (error) {
            console.error(error);
            $.LoadingOverlay('hide');
            msgErro(`Não foi possível gravar as comissões! Erro: ${error}. Verifique e tente novamente.`);
            return;
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#btnAdicionar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const ordem = $('#txtOrdem').val();
            const codigo = tipoCodigo == 'M' ? pegaChave('#txtMaterial') : pegaChave('#txtProduto');
            const descCodigo = tipoCodigo == 'M' ? pegaDescricao('#txtMaterial') : pegaDescricao('#txtProduto');
            const tabPreco = pegaChave('#txtTabPreco');
            const descTabPreco = pegaDescricao('#txtTabPreco');
            const codRep = pegaChave('#txtRepresentante');
            const nomeRep = pegaDescricao('#txtRepresentante');
            const valorUm = parseFloat($('#txtValor01').val() == '' ? '0' : $('#txtValor01').val().replace(',', '.'));
            const comissaoUm = parseFloat($('#txtCom01').val() == '' ? '0' : $('#txtCom01').val().replace(',', '.'));
            const valorDois = parseFloat($('#txtValor02').val() == '' ? '0' : $('#txtValor02').val().replace(',', '.'));
            const comissaoDois = parseFloat($('#txtCom02').val() == '' ? '0' : $('#txtCom02').val().replace(',', '.'));
            const valorTres = parseFloat($('#txtValor03').val() == '' ? '0' : $('#txtValor03').val().replace(',', '.'));
            const comissaoTres = parseFloat($('#txtCom03').val() == '' ? '0' : $('#txtCom03').val().replace(',', '.'));

            if (ordem == '') {
                msgAlerta('Não é possível adicionar comissões sem ordem informada! Favor clicar no campo e em seguida fora dele para gerar um número de ordem.');
                $.LoadingOverlay('hide');
                return
            };

            if (tabPreco == '') {
                msgAlerta('Não é possível adicionar comissões sem tabela de preço informada! Favor informar uma tabela de preço e tentar novamente.');
                $.LoadingOverlay('hide');
                return
            };

            if (codigo == '') {
                msgAlerta(`Não é possível adicionar comissões sem ${tipoCodigo == 'M' ? 'material' : 'produto'} informado! Favor informar um ${tipoCodigo == 'M' ? 'material' : 'produto'} e tentar novamente.`);
                $.LoadingOverlay('hide');
                return
            };

            if (valorUm >= valorDois) {
                msgAlerta('Valor 02 tem que ser maior que o Valor 01! Por favor, verifique.');
                $.LoadingOverlay('hide');
                return
            };

            if (valorDois >= valorTres && valorTres != 0) {
                msgAlerta('Valor 03 tem que ser maior que o Valor 02! Por favor, verifique.');
                $.LoadingOverlay('hide');
                return
            };

            const index = arrayComissoes.findIndex(comissao => comissao.codigo == codigo
                && comissao.codRep == codRep
                && comissao.tabPreco == tabPreco);

            if (index != -1) {
                msgAlerta('Comissão já adicionada! Por favor, verifique.');
                $.LoadingOverlay('hide');
                return
            } else {
                let comissao = {
                    codigo: codigo,
                    codRep: codRep,
                    tabPreco: tabPreco,
                }

                arrayComissoes.push(comissao);
            };

            const com1 = {
                SEQUENCIA: ordem,
                CODIGO: codigo,
                DESC_ITEN: descCodigo,
                DESC_DE: valorUm,
                DESC_ATE: valorDois - 0.01,
                COMISSAO: comissaoUm,
                TIPO: tipoCodigo,
                REPRESENTANTE: codRep,
                NOME_REP: nomeRep,
                TAB_PRE: tabPreco,
                DESC_TABPRECO: descTabPreco,
                DESCONTO: 0
            }; 

            $('#tabelaComissoesCadastro').DataTable().row.add(com1).draw(false);

            const com2 = {
                SEQUENCIA: ordem,
                CODIGO: codigo,
                DESC_ITEN: descCodigo,
                DESC_DE: valorDois,
                DESC_ATE: valorTres > 0 ? (valorTres - 0.01) : 99999.99,
                COMISSAO: comissaoDois,
                TIPO: tipoCodigo,
                REPRESENTANTE: codRep,
                NOME_REP: nomeRep,
                TAB_PRE: tabPreco,
                DESC_TABPRECO: descTabPreco,
                DESCONTO: 0
            }; 

            $('#tabelaComissoesCadastro').DataTable().row.add(com2).draw(false);


            if (valorTres > 0) {
                const com3 = {
                    SEQUENCIA: ordem,
                    CODIGO: codigo,
                    DESC_ITEN: descCodigo,
                    DESC_DE: valorTres,
                    DESC_ATE: 99999.99,
                    COMISSAO: comissaoTres,
                    TIPO: tipoCodigo,
                    REPRESENTANTE: codRep,
                    NOME_REP: nomeRep,
                    TAB_PRE: tabPreco,
                    DESC_TABPRECO: descTabPreco,
                    DESCONTO: 0
                }; 

                $('#tabelaComissoesCadastro').DataTable().row.add(com3).draw(false);
            };

            $('#txtTabPreco').val('');
            $('#txtProduto').val('');
            $('#txtMaterial').val('');
            $('#txtRepresentante').val('');
            $('#txtValor01').val('');
            $('#txtCom01').val('');
            $('#txtValor02').val('');
            $('#txtCom02').val('');
            $('#txtValor03').val('');
            $('#txtCom03').val('');
        } catch (error) {
            console.error(error);
            msgAlerta('Não foi possível adicionar comissões. Por favor, verifique.');
        } finally {
            $.LoadingOverlay('hide');
            if($('#txtOrdem').prop('disabled'))
            $('#txtOrdem').prop('disabled', true);
        }
    });

    async function buscaComissoesSeq() {
        $.LoadingOverlay('show');
        try {
            if (sequencia == 'create') {
                $('#tabelaComissoesCadastro').DataTable({
                    destroy: true,
                    ordering: false,
                    lengthChange: false,
                    serverside: false,
                    searching: false,
                    pageLength: 6,
                    "autoWidth": true,
                    "columns": [
                    {
                        "data": "SEQUENCIA"
                    },
                    {
                        "data": "CODIGO"
                    },
                    {
                        "data": "DESC_ITEN"
                    },
                    {
                        "data": "DESC_DE"
                    },
                    {
                        "data": "DESC_ATE"
                    },
                    {
                        "data": "COMISSAO"
                    },
                    {
                        "data": "TIPO"
                    },
                    {
                        "data": "REPRESENTANTE"
                    },
                    {
                        "data": "NOME_REP"
                    },
                    {
                        "data": "TAB_PRE"
                    },
                    {
                        "data": "DESC_TABPRECO"
                    },
                    {
                        "data": "DESCONTO"
                    }
                ],
                "columnDefs": [
                    {
                        render(data) {
                            return parseFloat(data).toLocaleString("pt-BR", {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2
                            });
                        },
                        targets: [3, 4],
                        "className": 'pr-4 text-right'
                    }
                ]
                });

                return
            }

            const url = `/sisplan/cadcomissao/v1/consultacomissoesedicao?`;

            const response = await requisicao("GET", url, `SEQUENCIA=${sequencia}`, '', 90000);

            const json = await response.json();

            if (json.length == 0) {
                $('#tabelaComissoesCadastro').DataTable({
                    destroy: true,
                    ordering: false,
                    lengthChange: false,
                    serverside: false,
                    searching: false,
                    pageLength: 6,
                    "autoWidth": true,
                    "columns": [
                    {
                        "data": "SEQUENCIA"
                    },
                    {
                        "data": "CODIGO"
                    },
                    {
                        "data": "DESC_ITEN"
                    },
                    {
                        "data": "DESC_DE"
                    },
                    {
                        "data": "DESC_ATE"
                    },
                    {
                        "data": "COMISSAO"
                    },
                    {
                        "data": "TIPO"
                    },
                    {
                        "data": "REPRESENTANTE"
                    },
                    {
                        "data": "NOME_REP"
                    },
                    {
                        "data": "TAB_PRE"
                    },
                    {
                        "data": "DESC_TABPRECO"
                    },
                    {
                        "data": "DESCONTO"
                    }
                ],
                "columnDefs": [
                    {
                        render(data) {
                            return parseFloat(data).toLocaleString("pt-BR", {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2
                            });
                        },
                        targets: [3, 4],
                        "className": 'pr-4 text-right'
                    }
                ]
                });
                return;
            }

            if (response.status != 200) {
                msgAlerta(json.mensagem);
                return;
            }

            $('#tabelaComissoesCadastro').DataTable({
                destroy: true,
                ordering: false,
                lengthChange: false,
                serverside: false,
                searching: false,
                "autoWidth": true,
                "data": json,
                "columns": [
                    {
                        "data": "SEQUENCIA"
                    },
                    {
                        "data": "CODIGO"
                    },
                    {
                        "data": "DESC_ITEN"
                    },
                    {
                        "data": "DESC_DE"
                    },
                    {
                        "data": "DESC_ATE"
                    },
                    {
                        "data": "COMISSAO"
                    },
                    {
                        "data": "TIPO"
                    },
                    {
                        "data": "REPRESENTANTE"
                    },
                    {
                        "data": "NOME_REP"
                    },
                    {
                        "data": "TAB_PRE"
                    },
                    {
                        "data": "DESC_TABPRECO"
                    },
                    {
                        "data": "DESCONTO"
                    }
                ],
                "columnDefs": [
                    {
                        render(data) {
                            return parseFloat(data).toLocaleString("pt-BR", {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2
                            });
                        },
                        targets: [3, 4],
                        "className": 'pr-4 text-right'
                    }
                ]
            }
            );
        } catch {

        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function deletaSequenciaComissoes(seq) {
        $.LoadingOverlay('show');
        try {
            const url = `/sisplan/cadcomissao/v1/excluisequencia?`;

            const filtros = `SEQUENCIA=${seq}`
            const response = await requisicao("DELETE", url, filtros, '', 90000);

            if (response.status != 200) {
                msgAlerta(json.mensagem);
                return;
            }

            $.LoadingOverlay('hide')

            await criaMensagemSucesso('Sequência de comissões excluída com sucesso!', () => {
                window.location.href = `${BASE_URI}/comissao`;
            });
        } catch (error) {
            console.error(error);
            $.LoadingOverlay('hide')
            msgErro('Não foi possível excluir essa sequência de comissões! Por favor, verifique.');
            return;
        }
    }

    await buscaComissoesSeq();

});