<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Cidade</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.257.10.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.257.10.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.257.10.1" />
  <link href='../dist/css/bootstrap.min.css?versao=3.257.10.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.257.10.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.257.10.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.257.10.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.257.10.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.257.10.1">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.257.10.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.257.10.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.257.10.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 100%;
      float: left;
      position: relative
    }

    .labelGeral {
      margin-top: 7px;
      margin-bottom: 3px;
    }

    .labelCheck {
      font-size: 120%;
      /* border-bottom: outset 2px;
            border-left: outset 2px; */
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
      padding: 10px;
    }

    .checkGroupRow {
      padding: 0;
      margin: 0;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px !important;
    }

    .btn-outline-danger {
      /* color: var(--blue) !important; */
      /* border: 1px solid var(--blue)  !important; */
      height: 45px;
    }

    .btn-block:not(.btn-basic) {
      color: inherit;
    }

    .btn-block {
      border: 1px solid !important;
      box-shadow: none !important;
      font-weight: 800 !important;
    }

    .btn-block:hover {
      border: 1px solid var(--danger) !important;
      color: var(--color-secondary) !important;
    }

    /* .btn-outline-danger {
      color: var(--blue) !important;
      border-color: var(--blue) !important;
    } */

    [class*="col-md"] {
      padding-left: 7.5px !important;
      padding-right: 7.5px !important;
    }

    textarea:focus {
      border-color: #c2121a !important;
    }

    textarea {
      background: #434343 !important;
      resize: none;
      font-size: 13.5px !important;
    }

    #toast-container>div {
      text-shadow: -1px 2px 4px rgb(0 0 0 / 96%) !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-12">
                <!-- <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="../cadcidade">Acesso Banco</a></li>
                  <li class="breadcrumb-item active">Cadastro de Banco</li>
                </ol> -->
              </div>
            </div>
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Cadastro de Cidade
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>
                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <!-- progressbar -->
                      <ul id="progressbar">
                        <li class="active" id="account"><strong>Geral</strong></li>
                      </ul>
                      <p>Preencha os dados e clique em gravar para realizar o cadastro ou alteração da Cidade</p>
                      <fieldset>
                        <div class="form-card" id="formcard1">
                          <div class="row">
                            <div class="col-12">

                              <div class="col">
                                <div class="row">
                                  <div class="form-group ml-sm-2 pr-sm-1 ml-0 pr-0 d-flex">
                                    <fieldset class="form border-Field mb-0 pb-0">
                                      <legend class="textoBorda mb-0 pb-0">Região</legend>
                                      <div class="form-row">
                                        <div class="icheck-primary pr-3">
                                          <input type="radio" id="rdCapital" name="rdRegiao" value="CA">
                                          <label for="rdCapital">Capital</label>
                                        </div>
                                        <div class="icheck-primary pr-3">
                                          <input type="radio" id="rdGradeCapital" name="rdRegiao" value="GC">
                                          <label for="rdGradeCapital">Grande Capital</label>
                                        </div>
                                        <div class="icheck-primary">
                                          <input type="radio" id="rdInterior" name="rdRegiao" value="IN">
                                          <label for="rdInterior">Interior</label>
                                        </div>
                                      </div>
                                    </fieldset>
                                  </div>

                                  <div class="form-group ml-0 ml-sm-2 ml-lg-2 d-flex">
                                    <fieldset class="form border-Field mb-0 pb-0">
                                      <legend class="textoBorda mb-0 pb-0">Suframa</legend>
                                      <div class="form-row">
                                        <div class="icheck-primary pr-3">
                                          <input type="checkbox" id="cbICMS" value="I">
                                          <label class="" for="cbICMS">Benefício ICMS</label>
                                        </div>
                                        <div class="icheck-primary pr-3">
                                          <input type="checkbox" id="cbPis" value="P">
                                          <label class="" for="cbPis">Benefício Pis</label>
                                        </div>
                                        <div class="icheck-primary">
                                          <input type="checkbox" id="cbCofins" value="C">
                                          <label for="cbCofins">Benefício Cofins</label>
                                        </div>
                                      </div>
                                    </fieldset>
                                  </div>
                                </div>
                              </div>


                              <div class="col-12">
                                <div class="row">
                                  <div class="col-12 col-sm-8 col-md-5 col-lg-6 col-xl-4 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Cód. Município/IBGE: *</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control validate" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="4201950">
                                      <button type="button" class="btn btn-block btn-outline-danger btn-sm" style="min-width: 100px; width: 100px" id="www"><i class="fa fa-desktop pr-2"></i>WWW</button>
                                    </div>
                                  </div>

                                  <div class="col-sm-4 col-md-4 col-lg-2 col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtIDH">Índice IDH:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control" id="txtIDH" name="txtIDH" class="form-control" placeholder="0.00">
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-sm-7 col-12 col-lg-7 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtMunicipio">Município: *</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control text-uppercase" maxlength="30" id="txtMunicipio" name="txtMunicipio" class="form-control" placeholder="Município">
                                    </div>
                                  </div>

                                  <div class="col-sm-5 col-lg-5 col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtUF">UF: *</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtUF" name="txtUF" class="form-control" placeholder="UF">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnUF" name="btnUF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaUF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                      </div>
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-12 col-sm-6 col-md-4 col-lg form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtTOM">Cód. TOM:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control validate" id="txtTOM" name="txtTOM" class="form-control" placeholder="0.00">
                                    </div>
                                  </div>

                                  <div class="col-12 col-sm-6 col-md-4 col-lg form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtEstadual">Cód. Estadual:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control validate" id="txtEstadual" name="txtEstadual" class="form-control" placeholder="0">
                                    </div>
                                  </div>

                                  <div class="col-12 col-sm-6 col-md-4 col-lg form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtISSQN">ISSQN:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control" id="txtISSQN" name="txtISSQN" class="form-control" placeholder="0.00">
                                    </div>
                                  </div>

                                  <div class="col-12 col-sm-6 col-md col-lg form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtIPC">IPC:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control" id="txtIPC" name="txtIPC" class="form-control" placeholder="0.00">
                                    </div>
                                  </div>

                                  <div class="col-12 col-sm-12 col-md col-lg form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPCV">PCV:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control" id="txtPCV" name="txtPCV" class="form-control" placeholder="0.00">
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-12 col-sm-6 col-md-4 col-lg form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPopulacao">População:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control" id="txtPopulacao" name="txtPopulacao" class="form-control" placeholder="0">
                                    </div>
                                  </div>

                                  <div class="col-12 col-sm-6 col-md-4 col-lg form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPopulacaoF">População F:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control validate" id="txtPopulacaoF" name="txtPopulacaoF" class="form-control" placeholder="0">
                                    </div>
                                  </div>

                                  <div class="col-12 col-sm-6 col-md-4 col-lg form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPopulacaoM">População M:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control validate" id="txtPopulacaoM" name="txtPopulacaoM" class="form-control" placeholder="0">
                                    </div>
                                  </div>

                                  <div class="col-12 col-sm-6 col-md-4 col-lg form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtDDD">DDD:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control" id="txtDDD" name="txtDDD" class="form-control">
                                    </div>
                                  </div>

                                  <div class="col-12 col-sm-12 col-md col-lg form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtFrete">% Frete Markup:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control" id="txtFrete" name="txtFrete" class="form-control" placeholder="0.00">
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-sm-6 col-lg-6 col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtRegiao">Regiao:</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtRegiao" name="txtRegiao" class="form-control" placeholder="Regiao">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnRegiao" name="btnRegiao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaRegiao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-sm-6 col-lg-6 col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPais">País:</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtPais" name="txtPais" class="form-control" placeholder="Pais">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnPais" name="btnPais" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaPais" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                      </div>
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="form-group col-12">
                                    <label data-error="wrong" data-success="right" for="txtObservacao">Observação:</label>
                                    <div class="input-group">
                                      <textarea id="txtObservacao" maxlength="1024" placeholder="Observação" class="form-control" rows="3"></textarea>
                                    </div>
                                  </div>
                                </div>

                              </div>

                              <div class="justify-content-end col">
                                <input type="button" name="gravar" class="btn-sisp next action-button" value="Gravar" id="gravar" />
                                <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                              </div>

                            </div>
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>

  <?php
  include_once('../../../modais.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <script src="../plugins/jquery/jquery.min.js?versao=3.257.10.1"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.257.10.1"></script>
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.257.10.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.257.10.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.257.10.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.257.10.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.257.10.1"></script>
  <script src="../utils/funcoes.js?versao=3.257.10.1"></script>
  <script src="../utils/cookies.js?versao=3.257.10.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.257.10.1"></script>
  <script src="../dist/js/dataTables.keyTable2.js?versao=3.257.10.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.257.10.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('CADCIDADE');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("CADCIDADE");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/cadcidade`
        });
        return;
      }

      //código para liberar registro ao sair da tela clicando no menu, breadcrumb
      const queryString = window.location.href;
      const parametros = queryString.split('/');
      const cidade = parametros[parametros.length - 1];

      $(window).on("beforeunload", function(e) {
        // e.preventDefault();
        e.stopPropagation();
        deletaRegistro('CADCIDADE', getCookie('usuario'), cidade);
        return undefined;
      });

      sArquivo = `${BASE_URI}/pages/cadcidade/cadastro_cadcidade/cadcidade.js?versao=3.257.10.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>