$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });

    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoBanco",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um banco.",
          position: "right",
        },
      },
      {
        element: "#tabelaAcessoBanco",
        popover: {
          title: "Tabela CadBanco",
          description: "Aqui estão os dados dos bancos cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  const permissaoUsuarioLogado = await permissaoAcessos("CADBANCO");

  $("#txtBancoConsulta").autocompleta(
    1, `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`
  )

  $("#btn-Banco").pesquisa(
    "#txtBancoConsulta",
    "BANCO",
    "NOME_BANCO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`,
    "Pesquisa Banco",
    "cadban"
  );

  $("#btn-limpa-Banco").on("click", function () {
    $("#txtBancoConsulta").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnNovoBanco").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cadbanco/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await ConsultaBancos(true);
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtBancoConsulta").val("");
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  ConsultaBancos();

  async function ConsultaBancos(bBotao = false) {
    try {
      let response;
      $.LoadingOverlay("show");
      let banco =
        pegaChave("#txtBancoConsulta") != ""
          ? ` AND BANCO = '${pegaChave("#txtBancoConsulta")}'`
          : "";
      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"], "where":  ["1=1 ${banco}"]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          'JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"], "where": null}',
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.acessoCadBanco == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadBanco: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      $("#tabelaAcessoBanco").DataTable({
        destroy: true,
        searching: true,
        paging: true,
        scrollX: true,
        scrollY: '350px',
        lengthChange: true,
        serverside: true,
        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "BANCO",
            title: "Banco"
          },
          {
            data: "NOME_BANCO",
            title: "Nome do Banco"
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $('#tabelaAcessoBanco_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaAcessoBanco_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaAcessoBanco").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso de cadastro de banco', '', '', 999, false, false, dados);
      });

      $('#tabelaAcessoBanco').DataTable().columns().every(function () {
        if ((colunasInvisiveis.acessoCadBanco).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaAcessoBanco').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCadBanco ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["BANCO"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadBanco: novasColunas }));

      $('#tabelaAcessoBanco').DataTable().columns().visible(true);

      $('#tabelaAcessoBanco').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  $("#tabelaAcessoBanco").on("click", "#btn-editar", async function () {

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaAcessoBanco").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("CADBANCO", data.BANCO);
      if (registroLiberado) {
        window.location.href = `cadbanco/${data.BANCO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }

  });

  $("#tabelaAcessoBanco").on("dblclick", "tr", async function () {

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaAcessoBanco").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("CADBANCO", data.BANCO);
      if (registroLiberado) {
        window.location.href = `cadbanco/${data.BANCO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }

  });

  $('#tabelaAcessoBanco').on('click', '#btn-excluir', async function () {

    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaAcessoBanco").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/cadbanco?", `BANCO=${encodeURIComponent(valorLinha.BANCO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});